<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="ch02s10.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="ch02s12.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="idp51051760"></a>2.11. Workflow Dashboard</h2></div></div></div>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>If you are running this tutorial through the hosted service then
        skip this step. To try out the workflow dashboard use the virtual
        machines provided above.</p>
</div>
<p>The Pegasus Dashboard is a web interface for monitoring and
    debugging workflows.</p>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The workflow dashboard can only monitor workflows which have
        been executed using Pegasus 4.2.0 and above.</p>
</div>
<p>To start the Pegasus Dashboard execute the following command</p>
<pre class="programlisting">$ pegasus-service --host 127.0.0.1 --port 5000

SSL is not configured: Using self-signed certificate
2015-04-13 16:14:23,074:Pegasus.service.server:79: WARNING: SSL is not configured: Using self-signed certificate
Service not running as root: Will not be able to switch users
2015-04-13 16:14:23,074:Pegasus.service.server:86: WARNING: Service not running as root: Will not be able to switch users</pre>
<p>By default, the dashboard server can only monitor workflows run by
    the current user i.e. the user who is running the pegasus-service.</p>
<p>To access the workflow dashboard, in the VirtualBox VM you can
    launch Firefox by clicking the globe icon in the top menu of the desktop.
    The home page for the dashboard is accessible at https://localhost:5000 .
    If you are using EC2 you will need to replace 'localhost' with the IP
    address of your EC2 instance.</p>
<p>The Dashboard's home page lists all workflows, which have been run
    by the current-user. The home page shows the status of each of the
    workflow i.e. Running/Successful/Failed/Failing. The home page lists only
    the top level workflows (Pegasus supports hierarchical workflows i.e.
    workflows within a workflow). The rows in the table are color coded</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p><span class="bold"><strong>Green</strong></span>: indicates workflow
        finished successfully.</p></li>
<li class="listitem"><p><span class="bold"><strong>Red</strong></span>: indicates workflow
        finished with a failure.</p></li>
<li class="listitem"><p><span class="bold"><strong>Blue</strong></span>: indicates a workflow is
        currently running.</p></li>
<li class="listitem"><p><span class="bold"><strong>Gray</strong></span>: indicates a workflow that
        was archived.</p></li>
</ul></div>
<div class="figure">
<a name="idp51065216"></a><p class="title"><b>Figure 2.3. Dashboard Home Page</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_home.png" width="100%" alt="Dashboard Home Page"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>To view details specific to a workflow, the user can click on
    corresponding workflow label. The workflow details page lists workflow
    specific information like workflow label, workflow status, location of the
    submit directory, etc. The details page also displays pie charts showing
    the distribution of jobs based on status.</p>
<p>In addition, the details page displays a tab listing all
    sub-workflows and their statuses. Additional tabs exist which list
    information for all running, failed, successful, and failing jobs.</p>
<p>The information displayed for a job depends on it's status. For
    example, the failed jobs tab displays the job name, exit code, links to
    available standard output, and standard error contents.</p>
<div class="figure">
<a name="idp51070144"></a><p class="title"><b>Figure 2.4. Dashboard Workflow Page</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_workflow_details.png" width="100%" alt="Dashboard Workflow Page"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>To view details specific to a job the user can click on the
    corresponding job's job label. The job details page lists information
    relevant to a specific job. For example, the page lists information like
    job name, exit code, run time, etc.</p>
<p>The job instance section of the job details page lists all attempts
    made to run the job i.e. if a job failed in its first attempt due to
    transient errors, but ran successfully when retried, the job instance
    section shows two entries; one for each attempt to run the job.</p>
<p>The job details page also shows tab's for failed, and successful
    task invocations (Pegasus allows users to group multiple smaller task's
    into a single job i.e. a job may consist of one or more tasks)</p>
<div class="figure">
<a name="idp51075104"></a><p class="title"><b>Figure 2.5. Dashboard Job Description Page</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_job_details.png" width="100%" alt="Dashboard Job Description Page"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The task invocation details page provides task specific information
    like task name, exit code, duration etc. Task details differ from job
    details, as they are more granular in nature.</p>
<div class="figure">
<a name="idp51078656"></a><p class="title"><b>Figure 2.6. Dashboard Invocation Page</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_invocation_details.png" width="100%" alt="Dashboard Invocation Page"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The dashboard also has web pages for workflow statistics and
    workflow charts, which graphically renders information provided by the
    pegasus-statistics and pegasus-plots command respectively.</p>
<p>The Statistics page shows the following statistics.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>Workflow level statistics</p></li>
<li class="listitem"><p>Job breakdown statistics</p></li>
<li class="listitem"><p>Job specific statistics</p></li>
</ol></div>
<div class="figure">
<a name="idp51086336"></a><p class="title"><b>Figure 2.7. Dashboard Statistics Page</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_statistics.png" width="100%" alt="Dashboard Statistics Page"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The Charts page shows the following charts.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>Job Distribution by Count/Time</p></li>
<li class="listitem"><p>Time Chart by Job/Invocation</p></li>
<li class="listitem"><p>Workflow Execution Gantt Chart</p></li>
</ol></div>
<p>The chart below shows the invocation distribution by count or
    time.</p>
<div class="figure">
<a name="idp51093904"></a><p class="title"><b>Figure 2.8. Dashboard Plots - Job Distribution</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_plots_job_dist.png" width="100%" alt="Dashboard Plots - Job Distribution"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The time chart shown below shows the number of jobs/invocations in
    the workflow and their total runtime</p>
<div class="figure">
<a name="idp51097376"></a><p class="title"><b>Figure 2.9. Dashboard Plots - Time Chart</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_plots_time_charts.png" width="100%" alt="Dashboard Plots - Time Chart"></td></tr></table></div></div>
</div>
<br class="figure-break"><p>The workflow gantt chart lays out the execution of the jobs in the
    workflow over time.</p>
<div class="figure">
<a name="idp51100832"></a><p class="title"><b>Figure 2.10. Dashboard Plots - Workflow Gantt Chart</b></p>
<div class="figure-contents"><div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/dashboard_plots_wf_gantt.png" width="100%" alt="Dashboard Plots - Workflow Gantt Chart"></td></tr></table></div></div>
</div>
<br class="figure-break">
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="ch02s10.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="tutorial.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="ch02s12.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">2.10. Collecting Statistics </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 2.12. Conclusion</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
