<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="glite.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="campus_cluster.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="7.7. Remote Cluster using BOSCO and SSH submissions">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="bosco_submission"></a>7.7. Remote Cluster using BOSCO and SSH submissions</h2></div></div></div>
<p><a class="ulink" href="http://bosco.opensciencegrid.org/about/" target="_top"> BOSCO</a>
    enables users to submit jobs to remote clusters using SSH. This section
    describes how to specify a site catalog entry for a site to which jobs can
    be submitted over SSH. To tag a site for SSH submission, the following
    profiles need to be specified for the site in the site catalog:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus</strong></span> profile <span class="bold"><strong>style</strong></span> with value set to <span class="bold"><strong>ssh</strong></span></p></li>
<li class="listitem"><p>Specify the service information as grid gateways. This should
        match what Bosco provided when the cluster was set up.</p></li>
</ol></div>
<p>An example site catalog entry for a BOSCO site looks as follows in
    the site catalog</p>
<pre class="programlisting">
&lt;sitecatalog xmlns="http://pegasus.isi.edu/schema/sitecatalog"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="http://pegasus.isi.edu/schema/sitecatalog http://pegasus.isi.edu/schema/sc-4.0.xsd"
             version="4.0"&gt;
    
    &lt;site  handle="USC_HPCC_Bosco" arch="x86_64" os="LINUX"&gt;

        &lt;!-- Specify the service information as grid gateways. This should match what Bosco provided when the cluster
             was set up. --&gt;
        &lt;grid type="batch" contact="username@hpc-login2.usc.edu" scheduler="PBS" jobtype="compute"/&gt;
        &lt;grid type="batch" contact="username@hpc-login2.usc.edu" scheduler="PBS" jobtype="auxillary"/&gt;

        &lt;!-- Scratch directory on the cluster --&gt;
        &lt;directory type="shared-scratch" path="/home/rcf-40/tmp"&gt;
            &lt;file-server operation="all" url="scp://username@hpc-login2.usc.edu/home/rcf-40/tmp"/&gt;
        &lt;/directory&gt;

        &lt;!-- SSH is the style to use for Bosco SSH submits --&gt;
        &lt;profile namespace="pegasus" key="style"&gt;ssh&lt;/profile&gt;

        &lt;!-- Bosco is using the grid universe, which means the globus
             namespace can be used to control the jobs --&gt;
        &lt;profile namespace="globus" key="queue"&gt;default&lt;/profile&gt;
        &lt;profile namespace="globus" key="maxwalltime"&gt;30&lt;/profile&gt;

    &lt;/site&gt;



&lt;/sitecatalog&gt;

</pre>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>It is recommended to have a submit node configured either as a
      BOSCO submit node or a vanilla HTCondor node. You cannot have HTCondor
      configured both as a BOSCO install and a traditional HTCondor submit
      node at the same time as BOSCO will override the traditional HTCondor
      pool in the user environment.</p>
</div>
<p>Starting 4.3 there is a bosco-shared-fs example in the examples
    directory of the distribution.</p>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="glite.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="execution_environments.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="campus_cluster.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.6. Local Cluster Using Glite </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.8. Campus Cluster</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
