<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-tc-converter.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-version.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-transfer">
<a name="cli-pegasus-transfer"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-transfer — Handles data transfers in Pegasus workflows.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-transfer_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-transfer</strong></span> [<span class="strong"><strong>-h</strong></span>]<br>
                   [<span class="strong"><strong>--file</strong></span> <span class="emphasis"><em>inputfile</em></span>]<br>
                   [<span class="strong"><strong>--threads</strong></span> <span class="emphasis"><em>number_threads</em></span>]<br>
                   [<span class="strong"><strong>--max-attempts</strong></span> <span class="emphasis"><em>attempts</em></span>]<br>
                   [<span class="strong"><strong>--debug</strong></span>]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-transfer_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-transfer</strong></span> takes a list of url pairs, either on stdin or with
an input file, determines the correct tool to use for the transfer and
executes the transfer. Some of the protocols pegasus-transfer can handle
are GridFTP, SRM, Amazon S3, HTTP, and local cp/symlinking. Failed
transfers are retried.</p>
<p>Note that pegasus-transfer is a tool mostly used internally in Pegasus
workflows, but the tool can be used stand alone as well.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-transfer_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-f</strong></span> <span class="emphasis"><em>inputfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--file</strong></span> <span class="emphasis"><em>inputfile</em></span>
</span>
</dt>
<dd>
File with input pairs. If not given, stdin will be used.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-m</strong></span>
, </span><span class="term">
<span class="strong"><strong>--max-attempts</strong></span> <span class="emphasis"><em>attempts</em></span>
</span>
</dt>
<dd>
Maximum number of attempts for retrying failed transfers.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t</strong></span>
, </span><span class="term">
<span class="strong"><strong>--threads</strong></span> <span class="emphasis"><em>number_threads</em></span>
</span>
</dt>
<dd>
The number of threads to use. This controls the parallelism of transfers.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span>
, </span><span class="term">
<span class="strong"><strong>--debug</strong></span>
</span>
</dt>
<dd>
Enables debugging output.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-transfer_example"></a><h2>Example</h2>
<pre class="screen">$ pegasus-transfer
# src 1 local_site
file:///etc/hosts
# dst 1 local_site
file:///tmp/foo
CTRL+D</pre>
</div>
<div class="refsect1" title="Credential Handling">
<a name="pegasus-transfer_credential_handling"></a><h2>Credential Handling</h2>
<p>Credentials used for transfers can be specified with a combination of
comments in the input file format and environment variables. For example,
give the following input file:</p>
<pre class="screen"># src 1 isi
gsiftp://workflow.isi.edu/data/file.dat
# dst 1 tacc_stampede
gsiftp://gridftp.stampede.tacc.utexas.edu/scratch/file.dat</pre>
<p>pegasus-transfer will expect either one environment variable specifying
one credential to be used on both end of the connection (X509_USER_PROXY),
or two separate environment variables specifying two different credentials
to be used on the two ends of the connection. The the latter case, the
environment variables are derived from the site names provided in the
input file commments. In the example above, the environment variables
would be named X509_USER_PROXY_isi and X509_USER_PROXY_tacc_stampede</p>
</div>
<div class="refsect1" title="Threading">
<a name="pegasus-transfer_threading"></a><h2>Threading</h2>
<p>In order to speed up data transfers, pegasus-transfer will start a set
of transfers in parallel using threads. Threads are turned off when
retrying failed transfers.</p>
</div>
<div class="refsect1" title="Author">
<a name="pegasus-transfer_author"></a><h2>Author</h2>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-tc-converter.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-version.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-tc-converter </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-version</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
