<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="transfer.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="ref_output_mapper.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="9.3. Credentials Management">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="cred_staging"></a>9.3. Credentials Management</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="cred_staging.php#x509_cred">9.3.1. X.509 Grid Proxies</a></span></dt>
<dt><span class="section"><a href="cred_staging.php#s3_cred">9.3.2. Amazon AWS S3</a></span></dt>
<dt><span class="section"><a href="cred_staging.php#gs_cred">9.3.3. Google Storage</a></span></dt>
<dt><span class="section"><a href="cred_staging.php#irods_cred">9.3.4. iRods Password</a></span></dt>
<dt><span class="section"><a href="cred_staging.php#ssh_cred">9.3.5. SSH Keys</a></span></dt>
</dl></div>
<p>Pegasus tries to do data staging from localhost by default, but some
    data scenarios makes some <a class="link" href="transfer.php#local_vs_remote_transfers" title="9.2.2. Local versus Remote Transfers">remote
    jobs do data staging</a>. An example of such a case is when running in
    <a class="link" href="transfer.php#ref_data_staging_configuration" title="9.2.1. Data Staging Configuration">nonsharedfs</a> mode.
    Depending on the transfer protocols used, the job may have to carry
    credentials to enable these data transfers. To specify where which
    credential to use and where Pegasus can find it, use environment variable
    profiles in your site catalog. The supported credential types are X.509
    grid proxies, Amazon AWS S3 keys, Google Cloud Platform OAuth token (.boto
    file), iRods password and SSH keys.</p>
<p>Credentials are usually associated per site in the site catalog.
    Users can associate the credentials either as a Pegasus profile or an
    environment profile with the site.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>A pegasus profile with the value pointing to the path to the
        credential on the local site or the submit host. If a pegasus
        credential profile associated with the site, then Pegasus
        automatically transfers it along with the remote jobs.</p></li>
<li class="listitem"><p>A env profile with the value pointing to the path to the
        credential on the remote site. If an env profile is specified, then no
        credential is transferred along with the job. Instead the job's
        environment is set to ensure that the job picks up the path to the
        credential on the remote site.</p></li>
</ol></div>
<div class="tip" title="Tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>Specifying credentials as Pegasus profiles was introduced in 4.4.0
      release.</p>
</div>
<p>In case of data transfer jobs, it is possible to associate different
    credentials for a single file transfer ( one for the source server and the
    other for the destination server) . For example, when leveraging GridFTP
    transfers between two sides that accept different grid credentials such as
    XSEDE Stampede site and NCSA Bluewaters. In that case, Pegasus picks up
    the associated credentials from the site catalog entries for the source
    and the destination sites associated with the transfer.</p>
<div class="section" title="9.3.1. X.509 Grid Proxies">
<div class="titlepage"><div><div><h3 class="title">
<a name="x509_cred"></a>9.3.1. X.509 Grid Proxies</h3></div></div></div>
<p>If the grid proxy is required by transfer jobs, and the proxy is
      in the standard location, Pegasus will pick the proxy up automatically.
      For non-standard proxy locations, you can use the
      <code class="varname">X509_USER_PROXY</code> environment variable. Site catalog
      example:</p>
<pre class="programlisting">&lt;profile namespace="pegasus" key="X509_USER_PROXY" &gt;/some/location/x509up&lt;/profile&gt;</pre>
</div>
<div class="section" title="9.3.2. Amazon AWS S3">
<div class="titlepage"><div><div><h3 class="title">
<a name="s3_cred"></a>9.3.2. Amazon AWS S3</h3></div></div></div>
<p>If a workflow is using s3 URLs, Pegasus has to be told where to
      find the .s3cfg file. This format of the file is described in the <a class="link" href="cli-pegasus-s3.php" title="pegasus-s3">pegaus-s3 command line client's man
      page</a>. For the file to be picked up by the workflow, set the
      <code class="varname">S3CFG</code> profile to the location of the file. Site
      catalog example:</p>
<pre class="programlisting">&lt;profile namespace="pegasus" pegasus="S3CFG" &gt;/home/user/.s3cfg&lt;/profile&gt;</pre>
</div>
<div class="section" title="9.3.3. Google Storage">
<div class="titlepage"><div><div><h3 class="title">
<a name="gs_cred"></a>9.3.3. Google Storage</h3></div></div></div>
<p>If a workflow is using gs:// URLs, Pegasus needs access to a
      Google Storage service account. First generate the credential by
      following the instructions at:</p>
<p><a class="ulink" href="https://cloud.google.com/storage/docs/authentication#service_accounts" target="_top">https://cloud.google.com/storage/docs/authentication#service_accounts</a></p>
<p>Download the credential in PKCS12 format, and then use "gsutil
      config -e" to generate a .boto file. For example:</p>
<pre class="programlisting">
$ gsutil config -e
This command will create a boto config file at /home/username/.boto
containing your credentials, based on your responses to the following
questions.
What is your service account email address? some-identifier@developer.gserviceaccount.com
What is the full path to your private key file? /home/username/my-cred.p12
What is the password for your service key file [if you haven't set one
explicitly, leave this line blank]? 

Please navigate your browser to https://cloud.google.com/console#/project,
then find the project you will use, and copy the Project ID string from the
second column. Older projects do not have Project ID strings. For such projects,
click the project and then copy the Project Number listed under that project.

What is your project-id? your-project-id

Boto config file "/home/username/.boto" created. If you need to use a
proxy to access the Internet please see the instructions in that file.
            </pre>
<p>Pegasus has to be told where to find both the .boto file as well
      as the PKCS12 file. For the files to be picked up by the workflow, set
      the <code class="varname">BOTO_CONFIG</code> and <code class="varname">GOOGLE_PKCS12</code>
      profiles for the storage site. Site catalog example:</p>
<pre class="programlisting">
&lt;profile namespace="pegasus" key="BOTO_CONFIG" &gt;/home/user/.boto&lt;/profile&gt;
&lt;profile namespace="pegasus" key="GOOGLE_PKCS12" &gt;/home/user/.google-service-account.p12&lt;/profile&gt;
</pre>
</div>
<div class="section" title="9.3.4. iRods Password">
<div class="titlepage"><div><div><h3 class="title">
<a name="irods_cred"></a>9.3.4. iRods Password</h3></div></div></div>
<p>If a workflow is using iRods URLs, Pegasus has to be given an
      irodsEnv file. It is a standard file, with the addtion of an password
      attribute. Example when using iRods 3.X:</p>
<pre class="programlisting"># iRODS personal configuration file.
#
# iRODS server host name:
irodsHost 'some.host.edu'
# iRODS server port number:
irodsPort 1259

# Account name:
irodsUserName 'someuser'
# Zone:
irodsZone 'somezone' 

# this is used with Pegasus
irodsPassword 'somesecretpassword'</pre>
<p>iRods 4.0 switched to a JSON based configuration file. Pegasus can handle
            either config file. JSON Example:</p>
<pre class="programlisting">
{
    "irods_host": "some.host.edu",
    "irods_port": 1247,
    "irods_user_name": "someuser",
    "irods_zone_name": "somezone",
    "irodsPassword" : "somesecretpassword"
}
</pre>
<p>The location of the file can be given to the workflow using the
      <code class="varname">irodsEnvFile</code> environment profile. Site catalog
      example:</p>
<pre class="programlisting">&lt;profile namespace="pegasus" key="irodsEnvFile" &gt;/home/user/.irods/.irodsEnv&lt;/profile&gt;</pre>
</div>
<div class="section" title="9.3.5. SSH Keys">
<div class="titlepage"><div><div><h3 class="title">
<a name="ssh_cred"></a>9.3.5. SSH Keys</h3></div></div></div>
<p>New in Pegasus 4.0 is the support for data staging with scp using
      ssh public/private key authentication. In this mode, Pegasus transports
      a private key with the jobs. The storage machines will have to have the
      public part of the key listed in ~/.ssh/authorized_keys.</p>
<div class="warning" title="Warning" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Warning</h3>
<p>SSH keys should be handled in a secure manner. In order to keep
        your personal ssh keys secure, It is recommended that a special set of
        keys are created for use with the workflow. Note that Pegasus will not
        pick up ssh keys automatically. The user will have to specify which
        key to use with <code class="varname"> SSH_PRIVATE_KEY</code>.</p>
</div>
<p>The location of the ssh private key can be specified with the
      <code class="varname">SSH_PRIVATE_KEY</code> environment profile. Site catalog
      example:</p>
<pre class="programlisting">&lt;profile namespace="pegasus" key="SSH_PRIVATE_KEY" &gt;/home/user/wf/wfsshkey&lt;/profile&gt;</pre>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="transfer.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="data_management.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="ref_output_mapper.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">9.2. Data Transfers </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 9.4. Output Mappers</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
