<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="useful_tips.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="migrating_from_2x.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="16.2. Migrating From Pegasus 3.1 to Pegasus 4.X">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="migrating_from_3x"></a>16.2. Migrating From Pegasus 3.1 to Pegasus 4.X</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="migrating_from_3x.php#idp36905824">16.2.1. Move to FHS layout</a></span></dt>
<dt><span class="section"><a href="migrating_from_3x.php#idp35708192">16.2.2. Stampede Schema Upgrade Tool</a></span></dt>
<dt><span class="section"><a href="migrating_from_3x.php#idp32949104">16.2.3. Existing users running in a condor pool with a non shared
      filesystem setup</a></span></dt>
<dt><span class="section"><a href="migrating_from_3x.php#idp45424720">16.2.4. New Clients for directory creation and file cleanup</a></span></dt>
</dl></div>
<p>With Pegasus 4.0 effort has been made to move the Pegasus
    installation to be FHS compliant, and to make workflows run better in
    Cloud environments and distributed grid environments. This chapter is for
    existing users of Pegasus who use Pegasus 3.1 to run their workflows and
    walks through the steps to move to using Pegasus 4.0</p>
<div class="section" title="16.2.1. Move to FHS layout">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp36905824"></a>16.2.1. Move to FHS layout</h3></div></div></div>
<p>Pegasus 4.0 is the first release of Pegasus which is <a class="ulink" href="http://www.pathname.com/fhs/" target="_top">Filesystem Hierarchy Standard
      (FHS)</a> compliant. The native packages no longer installs under
      /opt. Instead, pegasus-* binaries are in /usr/bin/ and example workflows
      can be found under /usr/share/pegasus/examples/.</p>
<p>To find Pegasus system components, a pegasus-config tool is
      provided. pegasus-config supports setting up the environment for</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem"><p>Python</p></li>
<li class="listitem"><p>Perl</p></li>
<li class="listitem"><p>Java</p></li>
<li class="listitem"><p>Shell</p></li>
</ul></div>
<p>For example, to find the PYTHONPATH for the DAX API, run:</p>
<pre class="programlisting">export PYTHONPATH=`pegasus-config --python`</pre>
<p>For complete description of pegasus-config, see the <a class="link" href="cli-pegasus-config.php" title="pegasus-config">man page</a>.</p>
</div>
<div class="section" title="16.2.2. Stampede Schema Upgrade Tool">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp35708192"></a>16.2.2. Stampede Schema Upgrade Tool</h3></div></div></div>
<p>Starting Pegasus 4.x the monitoring and statistics database schema
      has changed. If you want to use the pegasus-statistics, pegasus-analyzer
      and pegasus-plots against a 3.x database you will need to upgrade the
      schema first using the schema upgrade tool
      /usr/share/pegasus/sql/schema_tool.py or
      /path/to/pegasus-4.x/share/pegasus/sql/schema_tool.py</p>
<p>Upgrading the schema is required for people using the MySQL
      database for storing their monitoring information if it was setup with
      3.x monitoring tools.</p>
<p>If your setup uses the default SQLite database then the new
      databases run with Pegasus 4.x are automatically created with the
      correct schema. In this case you only need to upgrade the SQLite
      database from older runs if you wish to query them with the newer
      clients.</p>
<p>To upgrade the database</p>
<pre class="programlisting">For SQLite Database

<span class="bold"><strong>cd /to/the/workflow/directory/with/3.x.monitord.db</strong></span>

Check the db version<span class="bold"><strong>

/usr/share/pegasus/sql/schema_tool.py -c connString=sqlite:////to/the/workflow/directory/with/workflow.stampede.db</strong></span>
2012-02-29T01:29:43.330476Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.init | 
2012-02-29T01:29:43.330708Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema.start | 
2012-02-29T01:29:43.348995Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema 
                                   | Current version set to: 3.1. 
2012-02-29T01:29:43.349133Z ERROR  netlogger.analysis.schema.schema_check.SchemaCheck.check_schema 
                                   | Schema version 3.1 found - expecting 4.0 - database admin will need to run upgrade tool.


Convert the Database to be version 4.x compliant<span class="bold"><strong>

/usr/share/pegasus/sql/schema_tool.py -u connString=sqlite:////to/the/workflow/directory/with/workflow.stampede.db
</strong></span>2012-02-29T01:35:35.046317Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.init | 
2012-02-29T01:35:35.046554Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema.start | 
2012-02-29T01:35:35.064762Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema 
                                  | Current version set to: 3.1. 
2012-02-29T01:35:35.064902Z ERROR  netlogger.analysis.schema.schema_check.SchemaCheck.check_schema 
                                  | Schema version 3.1 found - expecting 4.0 - database admin will need to run upgrade tool. 
2012-02-29T01:35:35.065001Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.upgrade_to_4_0 
                                  | Upgrading to schema version 4.0.

Verify if the database has been converted to Version 4.x<span class="bold"><strong>

/usr/share/pegasus/sql/schema_tool.py -c connString=sqlite:////to/the/workflow/directory/with/workflow.stampede.db</strong></span>
2012-02-29T01:39:17.218902Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.init | 
2012-02-29T01:39:17.219141Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema.start | 
2012-02-29T01:39:17.237492Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema | Current version set to: 4.0. 
2012-02-29T01:39:17.237624Z INFO   netlogger.analysis.schema.schema_check.SchemaCheck.check_schema | Schema up to date. 

For upgrading a MySQL database the steps remain the same. The only thing that changes is the connection String to the database
E.g.<span class="bold"><strong>

/usr/share/pegasus/sql/schema_tool.py -u connString=mysql://username:password@server:port/dbname

</strong></span></pre>
<p>After the database has been upgraded you can use either 3.x or 4.x
      clients to query the database with <span class="bold"><strong>pegasus-statistics</strong></span>, as well as <span class="bold"><strong>pegasus-plots </strong></span>and <span class="bold"><strong>pegasus-analyzer.</strong></span></p>
</div>
<div class="section" title="16.2.3. Existing users running in a condor pool with a non shared filesystem setup">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp32949104"></a>16.2.3. Existing users running in a condor pool with a non shared
      filesystem setup</h3></div></div></div>
<p>Existing users that are running workflows in a cloud environment
      with a non shared filesystem setup have to do some trickery in the site
      catalog to include placeholders for local/submit host paths for
      execution sites when using CondorIO. In Pegasus 4.0, this has been
      rectified.</p>
<p>For example, for a 3.1 user, to run on a local-condor pool without
      a shared filesystem and use Condor file IO for file transfers, the site
      entry looks something like this</p>
<pre class="programlisting"> &lt;site  handle="local-condor" arch="x86" os="LINUX"&gt;
        &lt;grid  type="gt2" contact="localhost/jobmanager-fork" scheduler="Fork" jobtype="auxillary"/&gt;
        &lt;grid  type="gt2" contact="localhost/jobmanager-condor" scheduler="unknown" jobtype="compute"/&gt;
        &lt;head-fs&gt;

          <span class="bold"><strong>&lt;!-- the paths for scratch filesystem are the paths on local site as we execute create dir job
               on local site. Improvements planned for 4.0 release.--&gt;</strong></span>
            &lt;scratch&gt;
                &lt;shared&gt;
                    &lt;file-server protocol="file" url="file:///" mount-point="/submit-host/scratch"/&gt;
                    &lt;internal-mount-point mount-point="/submit-host/scratch"/&gt;
                &lt;/shared&gt;
            &lt;/scratch&gt;
            &lt;storage&gt;
                &lt;shared&gt;
                    &lt;file-server protocol="file" url="file:///" mount-point="/glusterfs/scratch"/&gt;
                    &lt;internal-mount-point mount-point="/glusterfs/scratch"/&gt;
                &lt;/shared&gt;
            &lt;/storage&gt;
        &lt;/head-fs&gt;
        &lt;replica-catalog  type="LRC" url="rlsn://dummyValue.url.edu" /&gt;
        &lt;profile namespace="env" key="PEGASUS_HOME" &gt;/cluster-software/pegasus/2.4.1&lt;/profile&gt;
        &lt;profile namespace="env" key="GLOBUS_LOCATION" &gt;/cluster-software/globus/5.0.1&lt;/profile&gt;

        <span class="bold"><strong>&lt;!-- profies for site to be treated as condor pool --&gt;</strong></span>
        &lt;profile namespace="pegasus" key="style" &gt;condor&lt;/profile&gt;
        &lt;profile namespace="condor" key="universe" &gt;vanilla&lt;/profile&gt;

        
        <span class="bold"><strong>&lt;!-- to enable kickstart staging from local site--&gt;</strong></span>
        &lt;profile namespace="condor" key="transfer_executable"&gt;true&lt;/profile&gt;


    &lt;/site&gt;
</pre>
<p>With Pegasus 4.0 the site entry for a local-condor pool can be as
      concise as the following</p>
<pre class="programlisting"> &lt;site  handle="condorpool" arch="x86" os="LINUX"&gt;
        &lt;head-fs&gt;
            &lt;scratch /&gt;
            &lt;storage /&gt;
        &lt;/head-fs&gt;
        &lt;profile namespace="pegasus" key="style" &gt;condor&lt;/profile&gt;
        &lt;profile namespace="condor" key="universe" &gt;vanilla&lt;/profile&gt;
    &lt;/site&gt;
</pre>
<p>The planner in 4.0 correctly picks up the paths from the local
      site entry to determine the staging location for the condor io on the
      submit host.</p>
<p>Users should read pegasus data staging configuration <a class="link" href="data_staging_configuration.php" title="5.3. Data Staging Configuration">chapter</a> and also look in the
      examples directory ( share/pegasus/examples).</p>
</div>
<div class="section" title="16.2.4. New Clients for directory creation and file cleanup">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp45424720"></a>16.2.4. New Clients for directory creation and file cleanup</h3></div></div></div>
<p>Pegasus 4.0 has new clients for directory creation and
      cleanup.</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem"><p>pegasus-create-dir</p></li>
<li class="listitem"><p>pegasus-cleanup</p></li>
</ul></div>
<p>Both these clients are python based wrapper scripts around various
      protocol specific clients that are used to determine what client to pick
      up.</p>
<div class="table">
<a name="idp47190032"></a><p class="title"><b>Table 16.1. Clients interfaced to by pegasus-create-dir</b></p>
<div class="table-contents"><table summary="Clients interfaced to by pegasus-create-dir" border="1">
<colgroup>
<col>
<col>
</colgroup>
<thead><tr>
<th>Client</th>
<th>Used For</th>
</tr></thead>
<tbody>
<tr>
<td>globus-url-copy</td>
<td>to create directories against a gridftp/ftp
              server</td>
</tr>
<tr>
<td>srm-mkdir</td>
<td>to create directories against a SRM server.</td>
</tr>
<tr>
<td>mkdir</td>
<td>to create a directory on the local filesystem</td>
</tr>
<tr>
<td>pegasus-s3</td>
<td>to create a s3 bucket in the amazon cloud</td>
</tr>
<tr>
<td>scp</td>
<td>staging files using scp</td>
</tr>
<tr>
<td>imkdir</td>
<td>to create a directory against an IRODS server</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="table">
<a name="idp45619520"></a><p class="title"><b>Table 16.2. Clients interfaced to by pegasus-cleanup</b></p>
<div class="table-contents"><table summary="Clients interfaced to by pegasus-cleanup" border="1">
<colgroup>
<col>
<col>
</colgroup>
<thead><tr>
<th>Client</th>
<th>Used For</th>
</tr></thead>
<tbody>
<tr>
<td>globus-url-copy</td>
<td>to remove a file against a gridftp/ftp server. In this
              case a zero byte file is created</td>
</tr>
<tr>
<td>srm-rm</td>
<td>to remove files against a SRM server.</td>
</tr>
<tr>
<td>rm</td>
<td>to remove a file on the local filesystem</td>
</tr>
<tr>
<td>pegasus-s3</td>
<td>to remove a file from the s3 bucket.</td>
</tr>
<tr>
<td>scp</td>
<td>to remove a file against a scp server. In this case a
              zero byte file is created.</td>
</tr>
<tr>
<td>irm</td>
<td>to remove a file against an IRODS server</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>With Pegasus 4.0, the planner will prefer to run the create dir
      and cleanup jobs locally on the submit host. The only case, where these
      jobs are scheduled to run remotely is when for the staging site, a file
      server is specified.</p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="useful_tips.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="useful_tips.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="migrating_from_2x.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 16. Useful Tips </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 16.3. Migrating From Pegasus 2.X to Pegasus 3.X</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
