<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-version.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="migrating_from_3x.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="" class="chapter">
<div class="titlepage"><div><div><h1 class="title">
<a name="useful_tips"></a>Chapter 16. Useful Tips</h1></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="useful_tips.php#migrating_from_leq44">16.1. Migrating From Pegasus &lt;4.5 to Pegasus &gt;=4.5</a></span></dt>
<dt><span class="section"><a href="migrating_from_3x.php">16.2. Migrating From Pegasus 3.1 to Pegasus 4.X</a></span></dt>
<dt><span class="section"><a href="migrating_from_2x.php">16.3. Migrating From Pegasus 2.X to Pegasus 3.X</a></span></dt>
<dt><span class="section"><a href="portable_code.php">16.4. Best Practices For Developing Portable Code</a></span></dt>
<dt><span class="section"><a href="cpu_affinity_condor.php">16.5. Slot Partitioning and CPU Affinity in Condor</a></span></dt>
</dl></div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="migrating_from_leq44"></a>16.1. Migrating From Pegasus &lt;4.5 to Pegasus &gt;=4.5</h2></div></div></div>
<p>Since Pegasus 4.5 all databases are managed by a single tool: <span class="bold"><strong>pegasus-db-admin</strong></span>. Databases will be automatically
    updated when <span class="bold"><strong>pegasus-planner</strong></span> is invoked, but
    it may require manually invocation of the <span class="bold"><strong>
    pegasus-db-admin</strong></span> for other Pegasus tools.</p>
<p>The <span class="bold"><strong>check</strong></span> command verifies if the
    database is compatible with the Pegasus' latest version. If the database is
    not compatible, it will print the following message:</p>
<pre class="programlisting">
$ pegasus-db-admin check
Your database is NOT compatible with version 4.5.0
    </pre>
<p>If you are running the <span class="bold"><strong>check</strong></span> command
    for the first time, the tool will prompt the following message:</p>
<pre class="programlisting">
Missing database tables or tables are not updated:
    dbversion
Run 'pegasus-db-admin update &lt;path_to_database&gt;' to create/update your database.
    </pre>
<p>To update the database, run the following command:</p>
<pre class="programlisting">
$ pegasus-db-admin update
Your database has been updated.
Your database is compatible with Pegasus version: 4.5.0
    </pre>
<p>The <span class="bold"><strong>pegasus-db-admin</strong></span> tool can operate 
    directly over a database URL, or can read configuration parameters from the 
    properties file or a submit directory. In the later case, a database type 
    should be provided to indicate which properties should be used to connect to 
    the database. For example, the tool will seek for <span class="emphasis"><em>pegasus.catalog.replica.db.*</em></span> 
    properties to connect to the JDBCRC database; or seek for <span class="emphasis"><em>pegasus.catalog.master.url</em></span>
    (or <span class="emphasis"><em>pegasus.dashboard.output</em></span>, which is deprecated) property
    to connect to the MASTER database; or seek for the <span class="emphasis"><em>pegasus.catalog.workflow.url</em></span>
    (or <span class="emphasis"><em>pegasus.monitord.output</em></span>, which is deprecated) property
    to connect to the WORKFLOW database. If none of these properties are found, the
    tool will connect to the default database in the user's home directory
    (sqlite:///${HOME}/.pegasus/workflow.db).</p>
<p>Example: connection by providing the URL to the database:</p>
<pre class="programlisting">
$ pegasus-db-admin create sqlite:///${HOME}/.pegasus/workflow.db
$ pegasus-db-admin update sqlite:///${HOME}/.pegasus/workflow.db
    </pre>
<p>Example: connection by providing a properties file that contains the
    information to connect to the database. Note that a database type (MASTER,
    WORKFLOW, or JDBCRC) should be provided:</p>
<pre class="programlisting">
$ pegasus-db-admin update -c pegasus.properties -t MASTER
$ pegasus-db-admin update -c pegasus.properties -t JDBCRC
$ pegasus-db-admin update -c pegasus.properties -t WORKFLOW
    </pre>
<p>Example: connection by providing the path to the submit directory  
    containning the <span class="emphasis"><em>braindump.txt</em></span> file, where information 
    to connect to the database can be extracted. Note that a database type 
    (MASTER, WORKFLOW, or JDBCRC) should also be provided:</p>
<pre class="programlisting">
$ pegasus-db-admin update -s /path/to/submitdir -t WORKFLOW
$ pegasus-db-admin update -s /path/to/submitdir -t MASTER
$ pegasus-db-admin update -s /path/to/submitdir -t JDBCRC
    </pre>
<p>Note that, if no URL is provided, the tool will create/use a SQLite 
    database in the user's home directory: 
    <span class="emphasis"><em>${HOME}/.pegasus/workflow.db</em></span>.</p>
<p>For complete description of pegasus-db-admin, see the <a class="link" href="cli-pegasus-db-admin.php" title="pegasus-db-admin">man page</a>.</p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-version.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="migrating_from_3x.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-version </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 16.2. Migrating From Pegasus 3.1 to Pegasus 4.X</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
