<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-config");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-config</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-config"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-config — Can be used to find installed Pegasus tools and libraries.</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-config_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-config</strong></span> [<span class="strong"><strong>-h</strong></span>] [<span class="strong"><strong>--help</strong></span>] [<span class="strong"><strong>-V</strong></span>] [<span class="strong"><strong>--version</strong></span>] [<span class="strong"><strong>--noeoln</strong></span>]<br>
               [<span class="strong"><strong>--perl-dump</strong></span>] [<span class="strong"><strong>--perl-hash</strong></span>] [<span class="strong"><strong>--python-dump</strong></span>] [<span class="strong"><strong>--sh-dump</strong></span>]<br>
               [<span class="strong"><strong>--bin</strong></span>] [<span class="strong"><strong>--conf</strong></span>] [<span class="strong"><strong>--java</strong></span>] [<span class="strong"><strong>--perl</strong></span>] [<span class="strong"><strong>--python</strong></span>]<br>
               [<span class="strong"><strong>--python-externals</strong></span>] [<span class="strong"><strong>--r</strong></span>] [<span class="strong"><strong>--schema</strong></span>] [<span class="strong"><strong>--classpath</strong></span>]<br>
               [<span class="strong"><strong>--local-site</strong></span>] [<span class="strong"><strong>--full-local</strong></span>]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-config_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-config</strong></span> is used to find locations of Pegasus system components.
The tool is used internally in Pegasus and by users who need to find paths
for DAX generator libraries and schemas.</p>
</div>
<div class="refsect1">
<a name="pegasus-config_options"></a><h2>Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints help and exits.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
Prints Pegasus version information
</dd>
<dt><span class="term">
<span class="strong"><strong>--perl-dump</strong></span>
</span></dt>
<dd>
Dumps all settings in perl format as separate variables.
</dd>
<dt><span class="term">
<span class="strong"><strong>--perl-hash</strong></span>
</span></dt>
<dd>
Dumps all settings in perl format as single perl hash.
</dd>
<dt><span class="term">
<span class="strong"><strong>--python-dump</strong></span>
</span></dt>
<dd>
Dumps all settings in python format.
</dd>
<dt><span class="term">
<span class="strong"><strong>--sh-dump</strong></span>
</span></dt>
<dd>
Dumps all settings in shell format.
</dd>
<dt><span class="term">
<span class="strong"><strong>--bin</strong></span>
</span></dt>
<dd>
Print the directory containing Pegasus binaries.
</dd>
<dt><span class="term">
<span class="strong"><strong>--conf</strong></span>
</span></dt>
<dd>
Print the directory containing configuration files.
</dd>
<dt><span class="term">
<span class="strong"><strong>--java</strong></span>
</span></dt>
<dd>
Print the directory containing the jars.
</dd>
<dt><span class="term">
<span class="strong"><strong>--perl</strong></span>
</span></dt>
<dd>
Print the directory to include into your PERL5LIB.
</dd>
<dt><span class="term">
<span class="strong"><strong>--python</strong></span>
</span></dt>
<dd>
Print the directory to include into your PYTHONLIB.
</dd>
<dt><span class="term">
<span class="strong"><strong>--python-externals</strong></span>
</span></dt>
<dd>
Print the directory to the external Python libraries.
</dd>
<dt><span class="term">
<span class="strong"><strong>--r</strong></span>
</span></dt>
<dd>
Print the path to the R DAX API source package.
</dd>
<dt><span class="term">
<span class="strong"><strong>--schema</strong></span>
</span></dt>
<dd>
Print the directory containing schemas.
</dd>
<dt><span class="term">
<span class="strong"><strong>--classpath</strong></span>
</span></dt>
<dd>
Builds a classpath containing the Pegasus jars.
</dd>
<dt><span class="term">
<span class="strong"><strong>--noeoln</strong></span>
</span></dt>
<dd>
Do not produce a end-of-line after output. This is useful when being
called from non-shell backticks in scripts. However, order is important
for this option: If you intend to use it, specify it first.
</dd>
<dt><span class="term">
<span class="strong"><strong>--local-site</strong></span> [d]
</span></dt>
<dd>
Create a site catalog entry for site "local". This is
only an XML snippet without root element nor XML
headers. The optional argument "d" points to the mount
point to use. If not specified, defaults to the user’s
$HOME directory.
</dd>
<dt><span class="term">
<span class="strong"><strong>--full-local</strong></span> [d]
</span></dt>
<dd>
Create a complete site catalog with only site "local".
The an XML snippet without root element nor XML headers.
The optional argument "d" points to the mount point to
use. If not specified, defaults to the user’s $HOME
directory.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-config_example"></a><h2>Example</h2>
<p>To set the PYTHONPATH variable in your shell for using the Python DAX
API:</p>
<pre class="screen">export PYTHONPATH=`pegasus-config --python`</pre>
<p>To set the same path inside Python:</p>
<pre class="screen">config = subprocess.Popen("pegasus-config --python-dump", stdout=subprocess.PIPE, shell=True).communicate()[0]
exec config</pre>
<p>To set the PERL5LIB variable in your shell for using the Perl DAX API:</p>
<pre class="screen">export PERL5LIB=`pegasus-config --perl`</pre>
<p>To set the same path inside Perl:</p>
<pre class="programlisting">eval `pegasus-config --perl-dump`;
die("Unable to eval pegasus-config output: $@") if $@;</pre>
<p>will set variables a number of lexically local-scoped <span class="strong"><strong>my</strong></span> variables
with prefix "pegasus_" and expand Perl’s search path for this script.</p>
<p>Alternatively, you can fail early and collect all Pegasus-related
variables into a single global <code class="literal">%pegasus</code> variable for convenience:</p>
<pre class="programlisting">BEGIN {
    eval `pegasus-config --perl-hash`;
    die("Unable to eval pegasus-config output: $@") if $@;
}</pre>
</div>
<div class="refsect1">
<a name="pegasus-config_author"></a><h2>Author</h2>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-cluster.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-configure-glite.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-cluster </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-configure-glite</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
