<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-mpi-keg");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-mpi-keg</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-mpi-keg"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-mpi-keg — MPI version of KEG</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-mpi-keg_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-mpi-keg</strong></span> [-a appname] [-t interval |-T interval] [-l logname]<br>
            [-P prefix] [-o fn [..]] [-i fn [..]] [-G sz] [-m memory]<br>
            [-r root_memory_allocation] [-C] [-e env [..]] [-p parm [..]]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-mpi-keg_description"></a><h2>Description</h2>
<p>The parallel version of kanonical executable is a stand-in for parallel binaries
in a DAG - but not for their arguments. It allows to trace the shape of the
execution of a DAG, and thus is an aid to debugging DAG related issues.</p>
<p>It works in the same way as the sequential version of <span class="strong"><strong>pegasus-keg</strong></span> but it is intended
to be executed as an MPI task. <span class="strong"><strong>pegasus-mpi-keg</strong></span> accepts the same parameters as
<span class="strong"><strong>pegasus-keg</strong></span>, so please refer to the <span class="strong"><strong>pegasus-keg</strong></span> manual page for more details.</p>
</div>
<div class="refsect1">
<a name="pegasus-mpi-keg_arguments"></a><h2>Arguments</h2>
<p>The same as <span class="strong"><strong>pegasus-keg</strong></span>. But there are some MPI-specific arguments.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-r root_memory_allocation_only</strong></span>
</span></dt>
<dd>
Works use only with the <span class="strong"><strong>-m</strong></span> option. When set, the memory allocation will
take place in the root MPI process only. By default, each MPI processe allocates
the amount of memory set by the <span class="strong"><strong>-m</strong></span> option.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-mpi-keg_return_value"></a><h2>Return Value</h2>
<p>The same as <span class="strong"><strong>pegasus-keg</strong></span>.</p>
</div>
<div class="refsect1">
<a name="pegasus-mpi-keg_example"></a><h2>Example</h2>
<p>The example shows the bracketing of an input file, and the copy
produced on the output file. For illustration purposes, the output
file is connected to <span class="emphasis"><em>stdout</em></span> :</p>
<pre class="screen">$ date &gt; xx
$ mpiexec -n 2 ./pegasus-mpi-keg -i xx -p a b c -o -
--- start xx ----
  Tue Dec  2 17:35:39 PST 2014
--- final xx ----
Timestamp Today: 20141202T173553.184-08:00 (1417570553.184;0.001)
Applicationname: pegasus-mpi-keg [36116e11c0735993bf54264953194e626fe4ab7e 2014-11-25] @ 138.25.147.42 (myc-2.local)
Current Workdir: /opt/pegasus/default/bin/pegasus-mpi-keg
Systemenvironm.: x86_64-Darwin 14.0.0
Processor Info.: 4 x Intel(R) Core(TM) i5-4278U CPU @ 2.60GHz
Load Averages  : 1.240 1.354 1.434
Memory Usage MB: 8192 total, 161 avail, 3599 active, 2496 inactive, 1077 wired
Swap Usage   MB: 2048 total, 1256 free
Filesystem Info: /                        hfs   232GB total,    66GB avail
Output Filename: -
Input Filenames: xx
Other Arguments: a b c</pre>
</div>
<div class="refsect1">
<a name="pegasus-mpi-keg_restrictions"></a><h2>Restrictions</h2>
<p>The same as <span class="strong"><strong>pegasus-keg</strong></span>.</p>
</div>
<div class="refsect1">
<a name="pegasus-mpi-keg_authors"></a><h2>Authors</h2>
<p>Pegasus - <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-mpi-cluster.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-plan.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-mpi-cluster </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-plan</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
