<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("Chapter 7. Execution Environments");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-node">Execution Environments</span>
</div><hr><div class="chapter">
<div class="titlepage"><div><div><h1 class="title">
<a name="execution_environments"></a>Chapter 7. Execution Environments</h1></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="execution_environments.php#localhost">7.1. Localhost</a></span></dt>
<dt><span class="section"><a href="condor_pool.php">7.2. Condor Pool</a></span></dt>
<dt><span class="section"><a href="cloud.php">7.3. Cloud (Amazon EC2/S3, Google Cloud, ...)</a></span></dt>
<dt><span class="section"><a href="pyglidein.php">7.4. Remote Cluster using PyGlidein</a></span></dt>
<dt><span class="section"><a href="globus_gram.php">7.5. Remote Cluster using Globus GRAM</a></span></dt>
<dt><span class="section"><a href="creamce_submission.php">7.6. Remote Cluster using CREAMCE</a></span></dt>
<dt><span class="section"><a href="glite.php">7.7. Local PBS Cluster Using Glite</a></span></dt>
<dt><span class="section"><a href="bosco_sdsc.php">7.8. SDSC Comet with BOSCO glideins</a></span></dt>
<dt><span class="section"><a href="bosco.php">7.9. Remote PBS Cluster using BOSCO and SSH</a></span></dt>
<dt><span class="section"><a href="campus_cluster.php">7.10. Campus Cluster</a></span></dt>
<dt><span class="section"><a href="xsede.php">7.11. XSEDE</a></span></dt>
<dt><span class="section"><a href="open_science_grid.php">7.12. Open Science Grid Using glideinWMS</a></span></dt>
</dl></div>
<p>Pegasus supports a number of execution environments. An execution
  environment is a setup where jobs from a workflow are running.</p>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="localhost"></a>7.1. Localhost</h2></div></div></div>
<p>In this configuration, Pegasus schedules the jobs to run locally on
    the submit host. Running locally is a good approach for smaller workflows,
    testing workflows, and for demonstations such as the <a class="link" href="tutorial.php" title="Chapter 2. Tutorial">Pegasus tutorial</a>. Pegasus supports two methods
    of local execution: local HTCondor pool, and shell planner. The former is
    preferred as the latter does not support all Pegasus' features (such as
    notifications).</p>
<p>Running on a local HTCondor pool is achieved by executing the
    workflow on site local (<span class="bold"><strong>--sites local</strong></span>
    option to pegasus-plan). The site "local" is a reserved site in Pegasus
    and results in the jobs to run on the submit host in HTCondor universe
    local. The site catalog can be left very simple in this case:</p>
<pre class="programlisting">
&lt;?xml version="1.0" encoding="UTF-8"?&gt;
&lt;sitecatalog xmlns="http://pegasus.isi.edu/schema/sitecatalog"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="http://pegasus.isi.edu/schema/sitecatalog http://pegasus.isi.edu/schema/sc-4.0.xsd"
             version="4.0"&gt;

    &lt;site  handle="local" arch="x86_64" os="LINUX"&gt;
        &lt;directory type="shared-scratch" path="/tmp/wf/work"&gt;
            &lt;file-server operation="all" url="file:///tmp/wf/work"/&gt;
        &lt;/directory&gt;
        &lt;directory type="local-storage" path="/tmp/wf/storage"&gt;
            &lt;file-server operation="all" url="file:///tmp/wf/storage"/&gt;
        &lt;/directory&gt;
    &lt;/site&gt;

&lt;/sitecatalog&gt;
</pre>
<p>The simplest execution environment does not involve HTCondor.
    Pegasus is capable of planning small workflows for local execution using a
    shell planner. Please refer to the <code class="filename">share/pegasus/examples</code> directory in your
    Pegasus installation, the shell planner's <a class="link" href="local_shell_examples.php" title="9.4. Local Shell Examples">documentation section</a>, or the
    tutorials, for details.</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="stampede_wf_events.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="condor_pool.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">6.6. Stampede Workflow Events </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.2. Condor Pool</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
