<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("Chapter 11. Optimizing Workflows for Efficiency and Scalability");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-node">Optimizing Workflows for Efficiency and Scalability</span>
</div><hr><div class="chapter">
<div class="titlepage"><div><div><h1 class="title">
<a name="optimization"></a>Chapter 11. Optimizing Workflows for Efficiency and Scalability</h1></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="optimization.php#short_jobs">11.1. Optimizing Short Jobs / Scheduling Delays</a></span></dt>
<dt><span class="section"><a href="job_clustering.php">11.2. Job Clustering</a></span></dt>
<dt><span class="section"><a href="large_workflows.php">11.3. How to Scale Large Workflows</a></span></dt>
<dt><span class="section"><a href="hierarchial_workflows.php">11.4. Hierarchical Workflows</a></span></dt>
<dt><span class="section"><a href="data_transfers.php">11.5. Optimizing Data Transfers</a></span></dt>
<dt><span class="section"><a href="job_throttling.php">11.6. Job Throttling</a></span></dt>
</dl></div>
<p>By default, Pegasus generates workflows which targets the most common
  usecases and execution environments. For more specialized environments or
  workflows, the following sections can provide hints on how to optimize your
  workflow to scale better, and run more efficient. Below are some common
  issues and solutions.</p>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="short_jobs"></a>11.1. Optimizing Short Jobs / Scheduling Delays</h2></div></div></div>
<p><span class="emphasis"><em>Issue:</em></span> Even though HTCondor is a high
    throughput system, there are overheads when scheduling short jobs. Common
    overheads include scheduling, data transfers, state notifications, and
    task book keeping. These overheads can be very noticeable for short jobs,
    but not noticeable at all for longer jobs as the ration between the
    computation and the overhead is higher.</p>
<p><span class="emphasis"><em>Solution:</em></span> If you have many short tasks to run,
    the solution to minimize the overheads is to use <a class="link" href="job_clustering.php" title="11.2. Job Clustering">task clustering</a>. This instructs Pegasus to
    take a set of tasks, selected <a class="link" href="job_clustering.php#horizontal_clustering" title="11.2.1.1.1. Horizontal Clustering">horizontally</a>, by <a class="link" href="job_clustering.php#label_clustering" title="11.2.1.1.3. Label Clustering">labels</a>, or by <a class="link" href="job_clustering.php#runtime_clustering" title="11.2.1.1.2. Runtime Clustering">runtime</a>, and create jobs containing
    that whole set of tasks. The result is more efficient jobs, for wich the
    overheads are less noticeable.</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="metadata.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="job_clustering.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">10.7. Metadata </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 11.2. Job Clustering</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
