<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("10.4. Staging Mappers");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="data_management.php">Data Management</a></span> &gt; <span class="breadcrumb-node">Staging Mappers</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="ref_staging_mapper"></a>10.4. Staging Mappers</h2></div></div></div>
<p>Starting 4.7 release, Pegasus has support for staging mappers in the
    <span class="bold"><strong>nonsharedfs</strong></span> data configuration. The
    staging mappers determine what sub directory on the staging site a job
    will be associated with. Before, the introduction of staging mappers, all
    files associated with the jobs scheduled for a particular site landed in
    the same directory on the staging site. As a result, for large workflows
    this could degrade filesystem performance on the staging servers.</p>
<p>To configure the staging mapper, you need to specify the following
    property</p>
<pre class="programlisting">pegasus.dir.staging.mapper  &lt;name of the mapper to use&gt;</pre>
<p>The following mappers are supported currently, with Hashed being the
    default .</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>Flat</strong></span> : This mapper results in
        Pegasus placing all the job submit files in the staging site directory
        as determined from the Site Catalog and planner options. This can
        result in too many files in one directory for large workflows, and was
        the only option before Pegasus 4.7.0 release.</p></li>
<li class="listitem">
<p><span class="bold"><strong>Hashed</strong></span> : This mapper results in
        the creation of a deep directory structure rooted at the staging site
        directory created by the create dir jobs. The binning is at the job
        level, and not at the file level i.e each job will push out it's
        outputs to the same directory on the staging site, independent of the
        number of output files. To control behavior of this mapper, users can
        specify the following properties</p>
<pre class="screen">pegasus.dir.staging.mapper.hashed.levels     the number of directory levels used to accomodate the files. Defaults to 2.
pegasus.dir.staging.mapper.hashed.multiplier the number of files associated with a job in the submit directory. defaults to 5.
</pre>
</li>
</ol></div>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The staging mappers are only triggered if
      pegasus.data.configuration is set to nonsharedfs</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cred_staging.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="data_management.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="ref_output_mapper.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">10.3. Credentials Management </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 10.5. Output Mappers</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
