<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-gridftp");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-gridftp</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-gridftp"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-gridftp — Perform file and directory operations on remote GridFTP servers</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-gridftp_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-gridftp</strong></span> <span class="strong"><strong>ls</strong></span> [options] [<span class="emphasis"><em>URL…</em></span>]<br>
<span class="strong"><strong>pegasus-gridftp</strong></span> <span class="strong"><strong>mkdir</strong></span> [options] [<span class="emphasis"><em>URL…</em></span>]<br>
<span class="strong"><strong>pegasus-gridftp</strong></span> <span class="strong"><strong>rm</strong></span> [options] [<span class="emphasis"><em>URL…</em></span>]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-gridftp</strong></span> is a client for Globus GridFTP servers. It enables remote
operations on files and directories via the GridFTP protocol. This tool was
created to enable more efficient remote directory creation and file cleanup
tasks in Pegasus.</p>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_options"></a><h2>Options</h2>
<div class="refsect2">
<a name="pegasus-gridftp_global_options"></a><h3>Global Options</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-v</strong></span>
</span></dt>
<dd>
Turn on verbose output. Verbosity can be increased by specifying multiple
-v arguments.
</dd>
<dt><span class="term">
<span class="strong"><strong>-i</strong></span> <span class="emphasis"><em>FILE</em></span>
</span></dt>
<dd>
Read a list of URLs to operate on from FILE.
</dd>
</dl></div>
</div>
<div class="refsect2">
<a name="pegasus-gridftp_rm_options"></a><h3>rm Options</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-f</strong></span>
</span></dt>
<dd>
If the URL does not exist, then ignore the error.
</dd>
<dt><span class="term">
<span class="strong"><strong>-r</strong></span>
</span></dt>
<dd>
Recursively delete files and directories.
</dd>
</dl></div>
</div>
<div class="refsect2">
<a name="pegasus-gridftp_ls_options"></a><h3>ls Options</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-a</strong></span>
</span></dt>
<dd>
List files beginning with a ".".
</dd>
<dt><span class="term">
<span class="strong"><strong>-l</strong></span>
</span></dt>
<dd>
Create a long-format listing with file size, creation date, type, permissions,
etc.
</dd>
</dl></div>
</div>
<div class="refsect2">
<a name="pegasus-gridftp_mkdir_options"></a><h3>mkdir Options</h3>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-p</strong></span>
</span></dt>
<dd>
Create intermediate directories as necessary.
</dd>
<dt><span class="term">
<span class="strong"><strong>-f</strong></span>
</span></dt>
<dd>
Ignore error if directory already exists
</dd>
</dl></div>
</div>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_subcommands"></a><h2>Subcommands</h2>
<p><span class="strong"><strong>pegasus-gridftp</strong></span> has several subcommands to implement different operations.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>ls</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>ls</strong></span> subcommand lists the details of a file, or the contents of a directory
on the remote server.
</dd>
<dt><span class="term">
<span class="strong"><strong>mkdir</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>mkdir</strong></span> subcommand creates one or more directories on the remote server.
</dd>
<dt><span class="term">
<span class="strong"><strong>rm</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>rm</strong></span> subcommand deletes one or more files and directories from the remote
server.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_url_format"></a><h2>URL Format</h2>
<p>All URLs supplied to <span class="strong"><strong>pegasus-gridftp</strong></span> should begin with "gsiftp://".</p>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_configuration"></a><h2>Configuration</h2>
<p><span class="strong"><strong>pegasus-gridftp</strong></span> uses the CoG JGlobus API to communicate with remote GridFTP
servers. Refer to the CoG JGlobus documentation for information about configuring
the API, such as how to specify the user’s proxy, etc.</p>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_return_value"></a><h2>Return Value</h2>
<p><span class="strong"><strong>pegasus-gridftp</strong></span> returns a zero exist status if the operation is successful.
A non-zero exit status is returned in case of failure.</p>
</div>
<div class="refsect1">
<a name="pegasus-gridftp_author"></a><h2>Author</h2>
<p>Gideon Juve <code class="literal">&lt;gideon@isi.edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-graphviz.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-halt.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-graphviz </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-halt</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
