<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-keg");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-keg</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-keg"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-keg — kanonical executable for grids</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-keg_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-keg</strong></span> [-a appname] [-t interval |-T interval] [-l logname]<br>
            [-P prefix] [-o fn [..]] [-i fn [..]] [-G sz [..]] [-m memory]<br>
            [-C] [-e env [..]] [-p parm [..]] [-u data_unit]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-keg_description"></a><h2>Description</h2>
<p>The kanonical executable is a stand-in for regular binaries in a DAG -
but not for their arguments. It allows to trace the shape of the
execution of a DAG, and thus is an aid to debugging DAG related issues.</p>
<p>Key feature of <span class="strong"><strong>pegasus-keg</strong></span> is that it can copy any number of input
files, including the <span class="emphasis"><em>generator</em></span> case, to any number of output files,
including the <span class="emphasis"><em>datasink</em></span> case. In addition, it protocols the IPv4 and
hostname of the host it ran upon, the current timestamp, and the run
time from start til the point of logging the information, the current
working directory and some information on the system environment.
<span class="strong"><strong>pegasus-keg</strong></span> will also report all input files, the current output files
and any requested string and environment value.</p>
<p>The workflow of the Keg tool is as follows:
- if <span class="strong"><strong>-m</strong></span> - allocate a memory buffer of the specified amount
- if <span class="strong"><strong>-i</strong></span> - read all input files into the memory buffer
- if <span class="strong"><strong>-o</strong></span> - write either the input files content (or a generated content
  if <span class="strong"><strong>-G</strong></span>) to output files
- if <span class="strong"><strong>-T</strong></span> - generate CPU load for the specified time period decreased by
  the time period spent on IO stuff; if the IO stuff time period exceeds
  the time period specified here the program exits with code status 3
- if <span class="strong"><strong>-t</strong></span> - wait/sleep for the specified time period decreased by time periods
  spent on IO stuff (and CPU load generating if any); if the time period spent
  on previous activities exceeds the amount specified here the program exits
  with code status 3
- if <span class="strong"><strong>-l</strong></span> - write info to the specified log file.</p>
</div>
<div class="refsect1">
<a name="pegasus-keg_arguments"></a><h2>Arguments</h2>
<p>The <span class="strong"><strong>-e</strong></span>, <span class="strong"><strong>-i</strong></span>, <span class="strong"><strong>-o</strong></span>, <span class="strong"><strong>-p</strong></span> and <span class="strong"><strong>-G</strong></span> arguments allow lists with arbitrary
number of arguments. These options may also occur repeatedly on the
command line. The file options may be provided with the special filename
- to indicate <span class="emphasis"><em>stdout</em></span> in append mode for writing, or <span class="emphasis"><em>stdin</em></span> for
reading. The <span class="strong"><strong>-a</strong></span>, <span class="strong"><strong>-l</strong></span> , <span class="strong"><strong>-P</strong></span> , <span class="strong"><strong>-T</strong></span> and <span class="strong"><strong>-t</strong></span> arguments should only
occur a single time with a single argument.</p>
<p>If <span class="strong"><strong>pegasus-keg</strong></span>
is called without any arguments, it will display its usage and exit with
success.</p>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>-a appname</strong></span>
</span></dt>
<dd>
This option allows <span class="strong"><strong>pegasus-keg</strong></span> to display a different name as its
applications. This mode of operation is useful in make-believe mode. The
default is the basename of <span class="emphasis"><em>argv[0]</em></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>-e env [..]</strong></span>
</span></dt>
<dd>
This option names any number of environment variables, whose value
should be reported as part of the data dump. By default, no environment
variables are reported.
</dd>
<dt><span class="term">
<span class="strong"><strong>-i infile [..]</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>pegasus-keg</strong></span> binary can work on any number of input files. For each
output file, every input file will be opened, and its content copied to
the output file. Textual input files are assumed. Each input line is
indented by two spaces. The input file content is bracketed between an
start and end section, see below. By default, <span class="strong"><strong>pegasus-keg</strong></span> operates in
<span class="emphasis"><em>generator</em></span> mode.
</dd>
<dt><span class="term">
<span class="strong"><strong>-l logfile</strong></span>
</span></dt>
<dd>
The <span class="emphasis"><em>logfile</em></span> is the name of a file to append atomically the self-info,
see below. The atomic write guarantees that the multi-line information
will not interleave with other processes that simultaneously write to
the same file. The default is not to use any log file.
</dd>
<dt><span class="term">
<span class="strong"><strong>-o outfile [..]</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>pegasus-keg</strong></span> can work on any number of output files. For each
output file, every input file will be opened, and its content copied
to the output file. Textual input files are assumed. Each input line
is indented by two spaces. The input file content is bracketed between
an start and end section, see 2nd example. After all input files are
copied, the data dump from this instance of <span class="strong"><strong>pegasus-keg</strong></span> is appended to
the output file. Without output files, <span class="strong"><strong>pegasus-keg</strong></span> operates in <span class="emphasis"><em>data
sink</em></span> mode.
Accept also <span class="emphasis"><em>&lt;filename&gt;=&lt;filesize&gt;&lt;data_unit&gt;</em></span> form, where &lt;data_unit&gt;
is a character supported by the <span class="strong"><strong>-u</strong></span> switch.
</dd>
<dt><span class="term">
<span class="strong"><strong>-G size [..]</strong></span>
</span></dt>
<dd>
If you want <span class="strong"><strong>pegasus-keg</strong></span> to generate a lot of output, the generator
option will do that for you. Just specify how much, in bytes (but you can change
it with <span class="strong"><strong>-u</strong></span> switch), you want. You can specify more than 1 value here if
you specify more than 1 output file. Subsequent values specified here will
correspond to sizes of subsequent output files.
This option is off by default.
</dd>
<dt><span class="term">
<span class="strong"><strong>-u data_unit</strong></span>
</span></dt>
<dd>
By default, the output data generator (the <span class="strong"><strong>-G</strong></span> switch) generates the specified
amount of data in Bytes. You can alter this behavior with this switch. It accepts
one of the following characters as <span class="emphasis"><em>data_unit</em></span> value: B for Bytes, K for KiloBytes,
M for MegaBytes, and G for GigaBytes.
</dd>
<dt><span class="term">
<span class="strong"><strong>-C</strong></span>
</span></dt>
<dd>
This option causes <span class="strong"><strong>pegasus-keg</strong></span> to list all environment variables that
start with the prefix <span class="emphasis"><em>\_CONDOR</em></span> The option is useful, if .B pegasus-keg
is run as (part of) a Condor job. This option is off by default.
</dd>
<dt><span class="term">
<span class="strong"><strong>-p string [..]</strong></span>
</span></dt>
<dd>
Any number of parameters can be reported, without being specific
on their content. Effectively, these strings are copied straight from
the command line. By default, no extra arguments are shown.
</dd>
<dt><span class="term">
<span class="strong"><strong>-P prefix</strong></span>
</span></dt>
<dd>
Each line from every input file is indented with a prefix string to
visually emphasize the provenance of an input files through multiple
instances of <span class="strong"><strong>pegasus-keg</strong></span>. By default, two spaces are used as prefix
string.
</dd>
<dt><span class="term">
<span class="strong"><strong>-t interval</strong></span>
</span></dt>
<dd>
The interval is an amount of sleep time that the <span class="strong"><strong>pegasus-keg</strong></span>
executable is to sleep in seconds. This can be used to emulate light work without
straining the pool resources. If used together with the <span class="strong"><strong>-T</strong></span> spin
option, the sleep interval comes before the spin interval. The default
is no sleep time.
</dd>
<dt><span class="term">
<span class="strong"><strong>-T interval</strong></span>
</span></dt>
<dd>
The interval is an amount of busy spin time that the <span class="strong"><strong>pegasus-keg</strong></span>
executable is to simulate intense computation in seconds. The simulation is done
by random julia set calculations. This option can be used to emulate an
intense work to strain pool resources. If used together with the <span class="strong"><strong>-t</strong></span>
sleep option, the sleep interval comes before the spin interval. The
default is no spin time.
</dd>
<dt><span class="term">
<span class="strong"><strong>-m memory</strong></span>
</span></dt>
<dd>
The amount of memory ([MB]) the Keg process should use. This option
can be used to emulated application’s memory requirements. The default
is not to allocate anything.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-keg_return_value"></a><h2>Return Value</h2>
<p>Execution as planned will return 0. The failure to open an input file
will return 1, the failure to open an output file, including the log
file, will return with exit code 2. If the time spent on IO exceeds
the specified time CPU load period with <span class="strong"><strong>-T</strong></span> or the time spent on IO
and CPU load exceeds the specified wall time with <span class="strong"><strong>-T</strong></span> the return code
will be 3.</p>
</div>
<div class="refsect1">
<a name="pegasus-keg_example"></a><h2>Example</h2>
<p>The example shows the bracketing of an input file, and the copy
produced on the output file. For illustration purposes, the output
file is connected to <span class="emphasis"><em>stdout</em></span> :</p>
<pre class="screen">$ date &gt; xx
$ pegasus-keg -i xx -p a b c -o -
--- start xx ----
  Thu May  5 10:55:45 PDT 2011
--- final xx ----
Timestamp Today: 20110505T105552.910-07:00 (1304618152.910;0.000)
Applicationname: pegasus-keg [3661M] @ 128.9.xxx.xxx (xxx.isi.edu)
Current Workdir: /opt/pegasus/default/bin/pegasus-keg
Systemenvironm.: x86_64-Linux 2.6.18-238.9.1.el5
Processor Info.: 4 x Intel(R) Core(TM) i5 CPU         750  @ 2.67GHz @ 2660.068
Load Averages  : 0.298 0.135 0.104
Memory Usage MB: 11970 total, 8089 free, 0 shared, 695 buffered
Swap Usage   MB: 12299 total, 12299 free
Filesystem Info: /                        ext3    62GB total,    20GB avail
Filesystem Info: /lfs/balefire            ext4  1694GB total,  1485GB avail
Filesystem Info: /boot                    ext2   493MB total,   447MB avail
Output Filename: -
Input Filenames: xx
Other Arguments: a b c</pre>
</div>
<div class="refsect1">
<a name="pegasus-keg_restrictions"></a><h2>Restrictions</h2>
<p>The input file must be textual files. The behaviour with binary files
is unspecified.</p>
<p>The host address is determined from the primary interface. If there is
no active interface besides loopback, the host address will default
to 0.0.0.0. If the host address is within a <span class="emphasis"><em>virtual private network</em></span>
address range, only <span class="emphasis"><em>(VPN)</em></span> will be displayed as hostname, and no
reverse address lookup will be attempted.</p>
<p>The
<span class="emphasis"><em>processor info</em></span>
line is only available on Linux systems. The line will be missing on
other operating systems. Its information is assuming symmetrical multi
processing, reflecting the CPU name and speed of the last CPU available
in
<span class="emphasis"><em>/dev/cpuinfo</em></span> .</p>
<p>There is a limit of
<span class="emphasis"><em>4 * page size</em></span>
to the output buffer of things that
.B pegasus-keg
can report in its self-info dump. There is no such restriction on the
input to output file copy.</p>
</div>
<div class="refsect1">
<a name="pegasus-keg_authors"></a><h2>Authors</h2>
<p>Jens-S. Vöckler &lt;voeckler at isi dot edu&gt;</p>
<p>Mike Wilde</p>
<p>Yong Zhao</p>
<p>Pegasus - <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-invoke.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-kickstart.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-invoke </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-kickstart</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
