<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-status");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-status</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-status"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-status — Pegasus workflow- and run-time status</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-status_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-status</strong></span> [<span class="strong"><strong>-h</strong></span>|<span class="strong"><strong>--help</strong></span>]<br>
               [<span class="strong"><strong>-V</strong></span>|<span class="strong"><strong>--version</strong></span>] [<span class="strong"><strong>-v</strong></span>|<span class="strong"><strong>--verbose</strong></span>] [<span class="strong"><strong>-d</strong></span>|<span class="strong"><strong>--debug</strong></span>]<br>
               [<span class="strong"><strong>-w</strong></span>|<span class="strong"><strong>--watch</strong></span> [<span class="emphasis"><em>s</em></span>]]<br>
               [<span class="strong"><strong>-L</strong></span>|<span class="strong"><strong>--[no]legend</strong></span>] [<span class="strong"><strong>-c</strong></span>|<span class="strong"><strong>--[no]color</strong></span>] [<span class="strong"><strong>-U</strong></span>|<span class="strong"><strong>--[no]utf8</strong></span>]<br>
               [<span class="strong"><strong>-Q</strong></span>|<span class="strong"><strong>--[no]queue</strong></span>] [<span class="strong"><strong>-i</strong></span>|<span class="strong"><strong>--[no]idle</strong></span>] [<span class="strong"><strong>--[no]held</strong></span>]<br>
               [<span class="strong"><strong>--[no]heavy</strong></span>] [<span class="strong"><strong>-S</strong></span>|<span class="strong"><strong>--[no]success</strong></span>]<br>
               [<span class="strong"><strong>-j</strong></span>|<span class="strong"><strong>--jobtype</strong></span> <span class="emphasis"><em>jt</em></span>] [<span class="strong"><strong>-s</strong></span>|<span class="strong"><strong>--site</strong></span> <span class="emphasis"><em>sid</em></span>]<br>
               [<span class="strong"><strong>-u</strong></span>|<span class="strong"><strong>--user</strong></span> <span class="emphasis"><em>name</em></span>]<br>
               { [<span class="strong"><strong>-l</strong></span>|<span class="strong"><strong>--long</strong></span>] | [<span class="strong"><strong>-r</strong></span>|<span class="strong"><strong>--rows</strong></span>] }<br>
               [<span class="emphasis"><em>rundir</em></span>]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-status_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-status</strong></span> shows the current state of the Condor Q and a workflow,
depending on settings. If no valid run directory could be determined,
including the current directory, <span class="strong"><strong>pegasus-status</strong></span> will show all jobs of
the current user and no workflows. If a run directory was specified, or
the current directory is a valid run directory, status about
the workflow will also be shown.</p>
<p>Many options will modify the behavior of this program, not withstanding
a proper UTF-8 capable terminal, watch mode, the presence of jobs in
the queue, progress in the workflow directory, etc.</p>
</div>
<div class="refsect1">
<a name="pegasus-status_options"></a><h2>Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a concise help and exits.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
Prints the version information and exits.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-w</strong></span> [<span class="emphasis"><em>sec</em></span>]
, </span><span class="term">
<span class="strong"><strong>--watch</strong></span> [<span class="emphasis"><em>sec</em></span>]
</span>
</dt>
<dd>
<p class="simpara">
This option enables the <span class="emphasis"><em>watch mode</em></span>. In watch mode, the program repeatedly
polls the status sources and shows them in an updating window. The optional
argument <span class="emphasis"><em>sec</em></span> to this option determines how often these sources are polled.
</p>
<p class="simpara">We <span class="emphasis"><em>strongly</em></span> recommend to set this interval not too low, as frequent polling
will degrade the scheduler performance and increase the host load. In watch
mode, the terminal size is the limiting factor, and parts of the output
may be truncated to fit it onto the given terminal.</p>
<p class="simpara">Watch mode is disabled by default. The <span class="emphasis"><em>sec</em></span> argument defaults to 60 seconds.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-L</strong></span>
, </span><span class="term">
<span class="strong"><strong>--legend</strong></span>
, </span><span class="term">
<span class="strong"><strong>--nolegend</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option shows a legend explaining the columns in the output, or turns off
legends.
</p>
<p class="simpara">By default, legends are turned off to save terminal real estate.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span>
, </span><span class="term">
<span class="strong"><strong>--color</strong></span>
, </span><span class="term">
<span class="strong"><strong>--nocolor</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option turns on (or off) ANSI color escape sequences in the output.
The single letter option can only switch on colors.
</p>
<p class="simpara">By default, colors are turned off, as they will not display well on a
terminal with black background.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-U</strong></span>
, </span><span class="term">
<span class="strong"><strong>--utf8</strong></span>
, </span><span class="term">
<span class="strong"><strong>--noutf8</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option turns on (or off) the output of Unicode box drawing characters
as UTF-8 encoded sequences. The single option can only turn on box drawing
characters.
</p>
<p class="simpara">The defaults for this setting depend on the <span class="emphasis"><em>LANG</em></span> environment variable.
If the variable contains a value ending in something indicating UTF-8
capabilities, the option is turned on by default. It is off otherwise.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-Q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--queue</strong></span>
, </span><span class="term">
<span class="strong"><strong>--noqueue</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option turns on (or off) the output from parsing Condor Q.
</p>
<p class="simpara">By default, Condor Q will be parsed for jobs of the current user. If a
workflow run directory is specified, it will furthermore be limited to jobs
only belonging to the workflow.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option increases the expert level, showing more information about the
condor_q state. Being an incremental option, two increases are supported.
</p>
<p class="simpara">Additionally, the signals <span class="emphasis"><em>SIGUSR1</em></span> and <span class="emphasis"><em>SIGUSR2</em></span> will increase and decrease
the expert level respectively during run-time.</p>
<p class="simpara">By default, the simplest queue view is enabled.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span>
, </span><span class="term">
<span class="strong"><strong>--debug</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This is an internal debugging tool and should not be used outside the
development team. As incremental option, it will show Pegasus-specific
ClassAd tuples for each job, more in the second level.
</p>
<p class="simpara">By default, debug mode is off.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-u</strong></span> <span class="emphasis"><em>name</em></span>
, </span><span class="term">
<span class="strong"><strong>--user</strong></span> <span class="emphasis"><em>name</em></span>
</span>
</dt>
<dd>
<p class="simpara">
This option permits to query the queue for a different user than the current
one. This may be of interest, if you are debugging the workflow of another
user.
</p>
<p class="simpara">By default, the current user is assumed.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-i</strong></span>
, </span><span class="term">
<span class="strong"><strong>--idle</strong></span>
, </span><span class="term">
<span class="strong"><strong>--noidle</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
With this option, jobs in Condor state <span class="emphasis"><em>idle</em></span> are omitted from the queue
output.
</p>
<p class="simpara">By default, <span class="emphasis"><em>idle</em></span> jobs are shown.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>--held</strong></span>
, </span><span class="term">
<span class="strong"><strong>--noheld</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option enables or disabled showing of the reason a job entered Condor’s
<span class="emphasis"><em>held</em></span> state. The reason will somewhat destroy the screen layout.
</p>
<p class="simpara">By default, the reason is shown.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>--heavy</strong></span>
, </span><span class="term">
<span class="strong"><strong>--noheavy</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
If the terminal is UTF-8 capable, and output is to a terminal, this option
decides whether to use heavyweight or lightweight line drawing characters.
</p>
<p class="simpara">By default, heavy lines connect the jobs to workflows.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-j</strong></span> <span class="emphasis"><em>jt</em></span>
, </span><span class="term">
<span class="strong"><strong>--jobtype</strong></span> <span class="emphasis"><em>jt</em></span>
</span>
</dt>
<dd>
<p class="simpara">
This option filters the Condor jobs shown only to the Pegasus jobtypes given
as argument or arguments to this option. It is a multi-option, and may be
specified multiple times, and may use comma-separated lists. Use this option
with an argument <span class="emphasis"><em>help</em></span> to see all valid and recognized jobtypes.
</p>
<p class="simpara">By default, all Pegasus jobtypes are shown.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>site</em></span>
, </span><span class="term">
<span class="strong"><strong>--site</strong></span> <span class="emphasis"><em>site</em></span>
</span>
</dt>
<dd>
<p class="simpara">
This option limits the Condor jobs shown to only those pertaining to the
(remote) site <span class="emphasis"><em>site</em></span>. This is an multi-option, and may be specified
multiple times, and may use comma-separated lists.
</p>
<p class="simpara">By default, all sites are shown.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-l</strong></span>
, </span><span class="term">
<span class="strong"><strong>--long</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option will show one line per sub-DAG, including one line for the
workflow. If there is only a single DAG pertaining to the <span class="emphasis"><em>rundir</em></span>,
only total will be shown.
</p>
<p class="simpara">This option is mutually exclusive with the <span class="strong"><strong>--rows</strong></span> option. If both are
specified, the <span class="strong"><strong>--long</strong></span> option takes precedence.</p>
<p class="simpara">By default, only DAG totals (sums) are shown.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-r</strong></span>
, </span><span class="term">
<span class="strong"><strong>--rows</strong></span>
, </span><span class="term">
<span class="strong"><strong>--norows</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option is shows the workflow summary statistics in rows instead of
columns. This option is useful for sending the statistics in email and
later viewing them in a proportional font.
</p>
<p class="simpara">This option is mutually exclusive with the <span class="strong"><strong>--long</strong></span> option. If both are
specified, the <span class="strong"><strong>--long</strong></span> option takes precedence.</p>
<p class="simpara">By default, the summary is shown in columns.</p>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-S</strong></span>
, </span><span class="term">
<span class="strong"><strong>--success</strong></span>
, </span><span class="term">
<span class="strong"><strong>--nosuccess</strong></span>
</span>
</dt>
<dd>
<p class="simpara">
This option modifies the previous <span class="strong"><strong>--long</strong></span> option. It will omit (or show)
fully successful sub-DAGs from the output.
</p>
<p class="simpara">By default, all DAGs are shown.</p>
</dd>
<dt><span class="term">
<span class="emphasis"><em>rundir</em></span>
</span></dt>
<dd>
<p class="simpara">
This option show statistics about the given DAG that runs in <span class="emphasis"><em>rundir</em></span>.
To gather proper statistics, <span class="strong"><strong>pegasus-status</strong></span> needs to traverse the
directory and all sub-directories. This can become an expensive
operation on shared filesystems.
</p>
<p class="simpara">By default, the <span class="emphasis"><em>rundir</em></span> is assumed to be the current directory. If
the current directory is not a valid <span class="emphasis"><em>rundir</em></span>, no DAG statistics will
be shown.</p>
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-status_return_value"></a><h2>Return Value</h2>
<p><span class="strong"><strong>pegasus-status</strong></span> will typically return success in regular mode, and the
termination signal in watch mode. Abnormal behavior will result in a
non-zero exit code.</p>
</div>
<div class="refsect1">
<a name="pegasus-status_example"></a><h2>Example</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>pegasus-status</strong></span>
</span></dt>
<dd>
This invocation will parse the Condor Q for the current user and show all
her jobs. Additionally, if the current directory is a valid Pegasus
workflow directory, totals about the DAG in that directory are displayed.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus-status -l rundir</strong></span>
</span></dt>
<dd>
As above, but providing a specific Pegasus workflow directory in argument
<span class="emphasis"><em>rundir</em></span> and requesting to itemize sub-DAGs.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus-status -j help</strong></span>
</span></dt>
<dd>
This option will show all permissible job types and exit.
</dd>
<dt><span class="term">
<span class="strong"><strong>pegasus-status -vvw 300 -Ll</strong></span>
</span></dt>
<dd>
This invocation will parse the queue, print it in high-expert mode, show
legends, itemize DAG statistics of the current working directory, and
redraw the terminal every five minutes with updated statistics.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-status_restrictions"></a><h2>Restrictions</h2>
<p>Currently only supports a single (optional) run directory. If you want to
watch multiple run directories, I suggest to open multiple terminals and
watch them separately. If that is not an option, or deemed too expensive,
you can ask <span class="emphasis"><em>pegasus-support at isi dot edu</em></span> to extend the program.</p>
</div>
<div class="refsect1">
<a name="pegasus-status_see_also"></a><h2>See Also</h2>
<p>condor_q(1), pegasus-statistics(1)</p>
</div>
<div class="refsect1">
<a name="pegasus-status_authors"></a><h2>Authors</h2>
<p>Jens-S. Vöckler <code class="literal">&lt;voeckler at isi dot edu&gt;</code></p>
<p>Gaurang Mehta <code class="literal">&lt;gmehta at isi dot edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-statistics.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-submit-dag.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-statistics </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-submit-dag</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
