<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("14.4. Jobstate.Log File");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="submit_directory.php">Submit Directory Details</a></span> &gt; <span class="breadcrumb-node">Jobstate.Log File</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="jobstate_log_file"></a>14.4. Jobstate.Log File</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="jobstate_log_file.php#submit_directory-delays">14.4.1. Pegasus Workflow Job States and Delays</a></span></dt></dl></div>
<p>The jobstate.log file logs the various states that a job goes
    through during workflow execution. It is created by the <span class="bold"><strong>pegasus-monitord</strong></span> daemon that is launched when a
    workflow is submitted to Condor DAGMan by pegasus-run. <span class="bold"><strong>pegasus-monitord</strong></span> parses the dagman.out file and
    writes out the jobstate.log file, the format of which is more amenable to
    parsing.</p>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The jobstate.log file is not created if a user uses
      condor_submit_dag to submit a workflow to Condor DAGMan.</p>
</div>
<p>The jobstate.log file can be created after a workflow has finished
    executing by running <span class="bold"><strong>pegasus-monitord</strong></span> on
    the .dagman.out file in the workflow submit directory.</p>
<p>Below is a snippet from the jobstate.log for a single job executed
    via condorg:</p>
<pre class="programlisting">1239666049 create_dir_blackdiamond_0_isi_viz SUBMIT 3758.0 isi_viz - 1
1239666059 create_dir_blackdiamond_0_isi_viz EXECUTE 3758.0 isi_viz - 1
1239666059 create_dir_blackdiamond_0_isi_viz GLOBUS_SUBMIT 3758.0 isi_viz - 1
1239666059 create_dir_blackdiamond_0_isi_viz GRID_SUBMIT 3758.0 isi_viz - 1
1239666064 create_dir_blackdiamond_0_isi_viz JOB_TERMINATED 3758.0 isi_viz - 1
1239666064 create_dir_blackdiamond_0_isi_viz JOB_SUCCESS 0 isi_viz - 1
1239666064 create_dir_blackdiamond_0_isi_viz POST_SCRIPT_STARTED - isi_viz - 1
1239666069 create_dir_blackdiamond_0_isi_viz POST_SCRIPT_TERMINATED 3758.0 isi_viz - 1
1239666069 create_dir_blackdiamond_0_isi_viz POST_SCRIPT_SUCCESS - isi_viz - 1</pre>
<p>Each entry in jobstate.log has the following:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>The ISO timestamp for the time at which the particular event
        happened.</p></li>
<li class="listitem"><p>The name of the job.</p></li>
<li class="listitem"><p>The event recorded by DAGMan for the job.</p></li>
<li class="listitem"><p>The condor id of the job in the queue on the submit node.</p></li>
<li class="listitem"><p>The pegasus site to which the job is mapped.</p></li>
<li class="listitem"><p>The job time requirements from the submit file.</p></li>
<li class="listitem"><p>The job submit sequence for this workflow.</p></li>
</ol></div>
<div class="table">
<a name="idm9081"></a><p class="title"><b>Table 14.1. The job lifecycle when executed as part of the
      workflow</b></p>
<div class="table-contents"><table class="table" summary="The job lifecycle when executed as part of the
      workflow" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>STATE/EVENT</strong></span></td>
<td><span class="bold"><strong>DESCRIPTION</strong></span></td>
</tr>
<tr>
<td>SUBMIT</td>
<td>job is submitted by condor schedd for execution.</td>
</tr>
<tr>
<td>EXECUTE</td>
<td>condor schedd detects that a job has started
            execution.</td>
</tr>
<tr>
<td>GLOBUS_SUBMIT</td>
<td>the job has been submitted to the remote resource. It's
            only written for GRAM jobs (i.e. gt2 and gt4).</td>
</tr>
<tr>
<td>GRID_SUBMIT</td>
<td>same as GLOBUS_SUBMIT event. The ULOG_GRID_SUBMIT event is
            written for all grid universe jobs./</td>
</tr>
<tr>
<td>JOB_TERMINATED</td>
<td>job terminated on the remote node.</td>
</tr>
<tr>
<td>JOB_SUCCESS</td>
<td>job succeeded on the remote host, condor id will be zero
            (successful exit code).</td>
</tr>
<tr>
<td>JOB_FAILURE</td>
<td>job failed on the remote host, condor id will be the job's
            exit code.</td>
</tr>
<tr>
<td>POST_SCRIPT_STARTED</td>
<td>post script started by DAGMan on the submit host, usually
            to parse the kickstart output</td>
</tr>
<tr>
<td>POST_SCRIPT_TERMINATED</td>
<td>post script finished on the submit node.</td>
</tr>
<tr>
<td>POST_SCRIPT_SUCCESS | POST_SCRIPT_FAILURE</td>
<td>post script succeeded or failed.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>There are other monitoring related files that are explained in the
    monitoring <a class="link" href="monitoring.php#monitoring-files" title="6.5.1.2. Monitoring related files in the workflow directory">chapter</a>.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="submit_directory-delays"></a>14.4.1. Pegasus Workflow Job States and Delays</h3></div></div></div>
<p>The various job states that a job goes through ( as caputured in
      the dagman.out and jobstate.log file) during it's lifecycle are
      illustrated below. The figure below highlights the various local and
      remote delays during job lifecycle.</p>
<div class="mediaobject"><table border="0" summary="manufactured viewport for HTML img" style="cellpadding: 0; cellspacing: 0;" width="100%"><tr><td><img src="images/Pegasus_Job_State_Delay.jpg" height="360"></td></tr></table></div>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="kickstart_xml_record.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="submit_directory.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="braindump_file.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">14.3. Kickstart XML Record </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 14.5. Braindump File</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
