<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("4.5. Variable Expansion");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="creating_workflows.php">Creating Workflows</a></span> &gt; <span class="breadcrumb-node">Variable Expansion</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="variable_expansion"></a>4.5. Variable Expansion</h2></div></div></div>
<p>Pegasus Planner supports notion of variable expansions in the DAX
    and the catalog files along the same lines as bash variable expansion
    works. This is often useful, when you want paths in your catalogs or
    profile values in the DAX to be picked up from the environment. An error
    is thrown if a variable cannot be expanded.</p>
<p>To specify a variable that needs to be expanded, the syntax is
    ${VARIABLE_NAME} , similar to BASH variable expansion. An important thing
    to note is that the variable names need to be enclosed in curly braces.
    For example</p>
<pre class="programlisting"> ${FOO}  - will be expanded by Pegasus
 $FOO    - will NOT be expanded by Pegasus.</pre>
<p>Also variable names are case sensitive.</p>
<p>Some examples of variable expansion are illustrated below:</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem">
<p><span class="bold"><strong>DAX</strong></span></p>
<p>A job in the DAX file needs to have a globus profile key project
        associated and the value has to be picked up (per user) from user
        environment.</p>
<pre class="programlisting">&lt;profile namespace="globus" key="project"&gt;${PROJECT}&lt;/profile&gt; 
</pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>Site Catalog</strong></span></p>
<p>In the site catalog, the site catalog entries are templated,
        where paths are resolved on the basis of values of environment
        variables. For example, below is a templated entry for a local site
        where $PWD is the working directory from where pegasus-plan is
        invoked.</p>
<pre class="programlisting">&lt;site  handle="local" arch="x86_64" os="LINUX" osrelease="" osversion="" glibc=""&gt;
        &lt;directory  path="${PWD}/LOCAL/shared-scratch" type="shared-scratch" free-size="" total-size=""&gt;
                &lt;file-server  operation="all" url="file:///${PWD}/LOCAL/shared-scratch"&gt;
                &lt;/file-server&gt;
        &lt;/directory&gt;    
        &lt;directory  path="${PWD}/LOCAL/shared-storage" type="shared-storage" free-size="" total-size=""&gt;
                &lt;file-server  operation="all" url="file:///${PWD}/LOCAL/shared-storage"&gt;
                &lt;/file-server&gt;
        &lt;/directory&gt;
        &lt;profile namespace="env" key="PEGASUS_HOME"&gt;/usr&lt;/profile&gt;
        &lt;profile namespace="pegasus" key="clusters.num" &gt;1&lt;/profile&gt;
&lt;/site&gt;
</pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>Replica Catalog</strong></span></p>
<p>The input file locations in the Replica Catalog can be resolved
        based on values of environment variables.</p>
<pre class="programlisting"># File Based Replica Catalog
production_200.conf file://$PWD/production_200.conf site="local" </pre>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>Variable expansion is only supported for File based Replica
          Catalog, not Regex or other file based formats.</p>
</div>
</li>
<li class="listitem">
<p><span class="bold"><strong>Transformation Catalog</strong></span></p>
<p>Similarly paths in the transformation catalog or profile values
        can be picked up from the environment i.e environment variables OS ,
        ARCH and PROJECT are defined in user environment when launching
        pegasus-plan.</p>
<pre class="programlisting"># Snippet from a Text Based Transformation Catalog
tr pegasus::keg{
    site obelix {
        profile globus "project" "${PROJECT}"
        pfn "/usr/bin/pegasus-keg"
        arch "${ARCH}"
        os "${OS}"
        type "INSTALLED"
    }
}</pre>
</li>
</ul></div>
<p></p>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="transformation.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="creating_workflows.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="running_workflows.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">4.4. Executable Discovery (Transformation Catalog) </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 5. Running Workflows</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
