<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("pegasus-db-admin");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="cli.php">Command Line Tools</a></span> &gt; <span class="breadcrumb-node">pegasus-db-admin</span>
</div><hr><div lang="en" class="refentry">
<a name="cli-pegasus-db-admin"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-db-admin — Manage Pegasus databases.</p>
</div>
<div class="refsynopsisdiv">
<a name="pegasus-db-admin_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-db-admin</strong></span> <span class="emphasis"><em>COMMAND</em></span> [options] [DATABASE_URL]</p></div></blockquote></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-db-admin</strong></span> is used to manage Pegasus databases. The tool can operate
directly over a database URL, or can read configuration parameters from the
properties file or a submit directory. In the later case, a database type
should be provided to indicate which properties should be used to connect to
the database. For example, the tool will seek for pegasus.catalog.replica.db.*
properties to connect to the JDBCRC database; or seek for pegasus.catalog.master.url
(or pegasus.dashboard.output, which is deprecated) property to connect to the
MASTER database; or seek for the pegasus.catalog.workflow.url (or pegasus.monitord.output,
which is deprecated) property to connect to the WORKFLOW database. If none of
these properties are found, the tool will connect to the default database</p>
<p>The <span class="strong"><strong>pegasus-db-admin</strong></span> tool should always be followed by a <span class="strong"><strong>COMMAND</strong></span> listed
below. To see the available options for each command, please use the <span class="strong"><strong>-h</strong></span> option
after the command. For example: <span class="strong"><strong>pegasus-db-admin update -h</strong></span></p>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_commands"></a><h2>Commands</h2>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">
<span class="strong"><strong>create DATABASE_URL</strong></span>
</span></dt>
<dd>
    Creates Pegasus databases from new or empty databases, or updates current
    database to the latest version. If a database already exists, it will
    create a backup (SQLite only) of the current database in the database folder
    as a 3-digit integer (e.g., workflow.db.000). Pegasus databases can be
    created by 1) passing a database URL, 2) from the properties file, and 3) from
    the submit directory. Note that if the properties file or the submit
    directory is used, a database type (JDBCRC, MASTER, or WORKFLOW) should be
    provided.
</dd>
<dt><span class="term">
<span class="strong"><strong>update <span class="emphasis"><em>[-a]</em></span> <span class="emphasis"><em>[-V]</em></span> DATABASE_URL</strong></span>
</span></dt>
<dd>
    Updates the database to the latest or a given Pegasus version provided with
    the <span class="strong"><strong>-V</strong></span> or <span class="strong"><strong>--version</strong></span> option. If a database already exists, it will
    create a backup (SQLite only) of the current database in the database folder
    as a 3-digit integer (e.g., workflow.db.000). The <span class="strong"><strong>-a</strong></span> or <span class="strong"><strong>--all</strong></span> option
    will also update databases from completed workflows in the MASTER database.
</dd>
<dt><span class="term">
<span class="strong"><strong>downgrade <span class="emphasis"><em>[-a]</em></span> <span class="emphasis"><em>[-V]</em></span> DATABASE_URL</strong></span>
</span></dt>
<dd>
    Downgrades the database to the previous or a given Pegasus version provided
    with the <span class="strong"><strong>-V</strong></span> or <span class="strong"><strong>--version</strong></span> option. If a database already exists, it will
    create a backup (SQLite only) of the current database in the database folder
    as a 3-digit integer (e.g., workflow.db.000). The <span class="strong"><strong>-a</strong></span> or <span class="strong"><strong>--all</strong></span> option
    will also downgrade databases from completed workflows in the MASTER database.
</dd>
<dt><span class="term">
<span class="strong"><strong>check <span class="emphasis"><em>[-V]</em></span> <span class="emphasis"><em>[-e]</em></span> DATABASE_URL</strong></span>
</span></dt>
<dd>
    Verifies if the database is updated to the latest or a given Pegasus version
    provided with the <span class="strong"><strong>-V</strong></span> or <span class="strong"><strong>--version</strong></span> option.
</dd>
<dt><span class="term">
<span class="strong"><strong>version <span class="emphasis"><em>[-V]</em></span> <span class="emphasis"><em>[-e]</em></span> DATABASE_URL</strong></span>
</span></dt>
<dd>
    Prints the current version of the database.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_global_options"></a><h2>Global Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c CONFIG_PROPERTIES</strong></span>
, </span><span class="term">
<span class="strong"><strong>--conf=CONFIG_PROPERTIES</strong></span>
</span>
</dt>
<dd>
Specifies the properties file. This overrides all other property files. Should
be used with <span class="emphasis"><em>-t</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s SUBMIT_DIR</strong></span>
, </span><span class="term">
<span class="strong"><strong>--submitdir=SUBMIT_DIR</strong></span>
</span>
</dt>
<dd>
Specifies the submit directory. Should be used with <span class="emphasis"><em>-t</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t DB_TYPE</strong></span>
, </span><span class="term">
<span class="strong"><strong>--type=DB_TYPE</strong></span>
</span>
</dt>
<dd>
Type of the database (JDBCRC, MASTER, or WORKFLOW). Should be used with <span class="emphasis"><em>-c</em></span>
or <span class="emphasis"><em>-s</em></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>-D PROPERTIES</strong></span>
</span></dt>
<dd>
Commandline overwrite for properties. Must be in the <span class="emphasis"><em>prop=val</em></span> format.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-d</strong></span>
, </span><span class="term">
<span class="strong"><strong>--debug</strong></span>
</span>
</dt>
<dd>
Enables debugging.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_update_and_downgrade_options"></a><h2>Update and Downgrade Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-a</strong></span>
, </span><span class="term">
<span class="strong"><strong>--all</strong></span>
</span>
</dt>
<dd>
Update/Downgrade all databases of completed workflows in MASTER.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V PEGASUS_VERSION</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version=PEGASUS_VERSION</strong></span>
</span>
</dt>
<dd>
Pegasus version that the database will be updated/downgraded to.
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_check_and_version_options"></a><h2>Check and Version Options</h2>
<div class="variablelist"><dl class="variablelist">
<dt>
<span class="term">
<span class="strong"><strong>-V PEGASUS_VERSION</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version=PEGASUS_VERSION</strong></span>
</span>
</dt>
<dd>
Pegasus version that the database will be updated/downgraded to.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-e</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version-value</strong></span>
</span>
</dt>
<dd>
Show actual version values (an integer number).
</dd>
</dl></div>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_database_upgrades_from_pegasus_4_5_x_to_pegasus_current_version"></a><h2>Database Upgrades From Pegasus 4.5.X to Pegasus current version</h2>
<p>Databases will be automatically updated when <span class="strong"><strong>pegasus-plan</strong></span> is invoked,
but WORKFLOW databases from past runs may not be updated accordingly.
Since Pegasus 4.6.0, the pegasus-db-admin tool provides an option to
automatically update all databases from completed workflows in the
MASTER database. To enable this option, run the following command:</p>
<pre class="screen">$ pegasus-db-admin update -a
Your database has been updated.
Your database is compatible with Pegasus version: 4.7.0

Verifying and updating workflow databases:
21/21

Summary:
Verified/Updated: 21/21
Failed: 0/21
Unable to connect: 0/21
Unable to update (active workflows): 0/21

Log files:
20161006T134415-dbadmin.out (Succeeded operations)
20161006T134415-dbadmin.err (Failed operations)</pre>
<p>This option generates a log file for succeeded operations, and a
log file for failed operations. Each file contains the list of URLs
of the succeeded/failed databases.</p>
<p>Note that, if no URL is provided, the tool will create/use a SQLite</p>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_examples"></a><h2>Examples</h2>
<pre class="screen"># Create a database by passing a database URL.
$ pegasus-db-admin create sqlite:///${HOME}/.pegasus/workflow.db
$ pegasus-db-admin create mysql://localhost:3306/pegasus

# Create a database from the properties file. Note that a database
# type should be provided.
$ pegasus-db-admin create -c pegasus.properties -t MASTER
$ pegasus-db-admin create -c pegasus.properties -t JDBCRC
$ pegasus-db-admin create -c pegasus.properties -t WORKFLOW

# Create a database from the submit directory. Note that a database
# type should be provided.
$ pegasus-db-admin update -s /path/to/submitdir -t WORKFLOW
$ pegasus-db-admin update -s /path/to/submitdir -t MASTER
$ pegasus-db-admin update -s /path/to/submitdir -t JDBCRC

# Update the database schema by passing a database URL.
$ pegasus-db-admin update sqlite:///${HOME}/.pegasus/workflow.db
$ pegasus-db-admin update mysql://localhost:3306/pegasus

# Update the database schema from the properties file. Note that a
# database type should be provided.
$ pegasus-db-admin update -c pegasus.properties -t MASTER
$ pegasus-db-admin update -c pegasus.properties -t JDBCRC
$ pegasus-db-admin update -c pegasus.properties -t WORKFLOW

# Update the database schema from the submit directory. Note that a
# database type should be provided.
$ pegasus-db-admin update -s /path/to/submitdir -t WORKFLOW
$ pegasus-db-admin update -s /path/to/submitdir -t MASTER
$ pegasus-db-admin update -s /path/to/submitdir -t JDBCRC</pre>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_troubleshooting"></a><h2>Troubleshooting</h2>
<p><span class="strong"><strong>Error 2013: Lost connection to MySQL server during query when dumping table</strong></span></p>
<p>When updating MySQL databases, pegasus-db-admin uses <span class="emphasis"><em><span class="strong"><strong>mysqldump</strong></span></em></span> to create a
backup .sql file for the current database. For very large databases, the dump
may fail due to timeout limits of the MySQL database (which are set to 30 seconds
for read, and 60 seconds for write). You can change these limits in the <span class="emphasis"><em><span class="strong"><strong>my.cnf</strong></span></em></span>
config file by setting the following configuration parameters (the values below
are only an example, you should adjust them as you may like):</p>
<pre class="screen">net_read_timeout = 120
net_write_timeout = 900</pre>
<p>After making these changes to my.cnf you must restart MySQL.</p>
</div>
<div class="refsect1">
<a name="pegasus-db-admin_authors"></a><h2>Authors</h2>
<p>Rafael Ferreira da Silva <code class="literal">&lt;rafsilva@isi.edu&gt;</code></p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-dax-validator.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-em.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-dax-validator </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-em</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
