<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("8.4. Staging of Application Containers");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="containers.php">Containers</a></span> &gt; <span class="breadcrumb-node">Staging of Application Containers</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="container-transfers"></a>8.4. Staging of Application Containers</h2></div></div></div>
<div class="toc"><dl class="toc"><dt><span class="section"><a href="container-transfers.php#container-symlinking">8.4.1. Symlinking</a></span></dt></dl></div>
<p>Pegasus treats containers as other files in terms of data
      management. Container to be used for a job is tracked as an input
      dependency that needs to be staged if it is not already there. Similar
      to executables, you specify the location for your container image in the
      Transformation Catalog. You can specify the source URL's for containers
      as the following.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem">
<p>URL to a container hosted on a central hub repository</p>
<p>Example of a docker hub URL is docker:///rynge/montage:latest,
          while for singularity shub://pegasus-isi/fedora-montage</p>
</li>
<li class="listitem">
<p>URL to a container image file on a file server.</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p><span class="bold"><strong>Docker - </strong></span>Docker supports
              loading of containers from a tar file, Hence, containers images
              can only be specified as tar files and the extension for the
              filename is not important.</p></li>
<li class="listitem">
<p><span class="bold"><strong>Singularity -</strong></span> Singularity
              supports container images in various forms and relies on the
              extension in the filename to determine what format the file is
              in. Pegasus supports the following extensions for singularity
              container images</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: circle; ">
<li class="listitem"><p>.img</p></li>
<li class="listitem"><p>.tar</p></li>
<li class="listitem"><p>.tar.gz</p></li>
<li class="listitem"><p>.tar.bz2</p></li>
<li class="listitem"><p>.cpio</p></li>
<li class="listitem"><p>.cpio.gz</p></li>
</ul></div>
<p>Singularity will fail to run the container if you don't
              specify the right extension , when specify the source URL for
              the image.</p>
</li>
</ul></div>
</li>
</ol></div>
<p>In both the cases, Pegasus will place the container image on the
      staging site used for the workflow, as part of the data stage-in nodes,
      using pegasus-transfer. When pulling in an image from a container hub
      repository, pegasus-transfer will export the container as a tar file in
      case of Docker, and as .img file in case of Singularity</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="container-symlinking"></a>8.4.1. Symlinking</h3></div></div></div>
<p>Since, Pegasus only mounts the job directory determined by
        PegasusLite into the application container, symlinking of input data
        sets does not work. This is because the symlink in PegasusLite
        directory points to a source directory on the worker node, that is not
        mounted in the container. Hence user's jobs would fail. Hence, Pegasus
        will automatically disable symlinking for jobs that use containers.
        The only exception being the application container itself. If you
        specify a URL for the container image, the image will be symlinked if
        Pegasus determines that it can be.</p>
<p>Enabling symlinking of containers is useful, when running large
        workflows on a single cluster. Pegasus can pull the image from the
        container repository once, and place it on the shared filesystem where
        it can then be symlinked from, when the PegasusLite jobs start on the
        worker nodes of that cluster. In order to do this, you need to be
        running the nonsharedfs data configuration mode with the staging site
        set to be the same as the compute site.</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="container-exec-model.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="containers.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="container-example.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">8.3. Container Execution Model </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 8.5. Container Example - Montage Workflow</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
