<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("7.7. Local PBS Cluster Using Glite");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="execution_environments.php">Execution Environments</a></span> &gt; <span class="breadcrumb-node">Local PBS Cluster Using Glite</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="glite"></a>7.7. Local PBS Cluster Using Glite</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="glite.php#glite_mappings">7.7.1. Setting job requirements</a></span></dt>
<dt><span class="section"><a href="glite.php#idm3681">7.7.2. Specifying a remote directory for the job</a></span></dt>
</dl></div>
<p>This section describes the configuration required for Pegasus to
    generate an executable workflow that uses glite to submit to a PBS or
    PBS-like batch system on a local cluster.</p>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>Glite is the old name for BLAH (or BLAHP). BLAH binaries are
      distributed with HTCondor as the "batch_gahp". For historical reasons,
      we often use the term "glite", and you will see "glite" and "batch_gahp"
      references in HTCondor, but all of them refer to the same thing, which
      has been renamed BLAH.</p>
</div>
<div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>This guide covers PBS, SGE and Moab, but glite also works with
      other PBS-like batch systems, including LSF, SLURM, Cobalt and others.
      If you need help configuring Pegasus and HTCondor to work with one of
      these systems, please contact pegasus-support@isi.edu. For the sake of
      brevity, the text below will say "PBS", but you should read that as "PBS
      or PBS-like system such as SGE, Moab, LSF, SLURM and others".</p>
</div>
<p>Glite needs to be able to talk directly with the batch system
    running on the cluster using <code class="literal">qsub</code>,
    <code class="literal">qstat</code> or equivalent commands. If you can submit jobs to
    PBS from the workflow submit host running Pegasus and HTCondor, then the
    local HTCondor can be used to submit jobs via glite (with some
    modifications described below). If you need to SSH to a different cluster
    head node in order to submit jobs to the PBS system, then you need to use
    BOSCO, which is <a class="link" href="bosco.php" title="7.9. Remote PBS Cluster using BOSCO and SSH"> documented in another
    section</a>.</p>
<div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>There is also a way to do remote job submission via glite even if
      you cannot SSH to the PBS head node. This might be the case, for
      example, if the head node requires 2-factor authentication (e.g. RSA
      tokens). This approach is called the "Reverse GAHP" and you can find out
      more information on the <a class="ulink" href="https://github.com/juve/rvgahp" target="_top">GitHub page</a>. All it
      requires is SSH from the cluster head node back to the workflow submit
      host.</p>
</div>
<p>In either case, you need to modifiy the HTCondor glite installation
    that will be used to submit jobs to the PBS system. To do this, run the
    <code class="literal">pegasus-configure-glite</code> command. This command will
    install all the required scripts to map Pegasus profiles to batch-system
    specific job attributes, and add support for Moab. You may need to run it
    as root depending on how you installed Condor.</p>
<p>In order to configure a workflow to use glite you need to create an
    entry in your site catalog for the PBS cluster and set the following
    profiles:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus</strong></span> profile <span class="bold"><strong>style</strong></span> with value set to <span class="bold"><strong>glite</strong></span>.</p></li>
<li class="listitem"><p><span class="bold"><strong>condor</strong></span> profile <span class="bold"><strong>grid_resource</strong></span> with value set to <span class="bold"><strong>batch pbs</strong></span> or <span class="bold"><strong>batch
        sge</strong></span> or <span class="bold"><strong>batch moab</strong></span>.</p></li>
</ol></div>
<p>An example site catalog entry for a local glite PBS site looks like
    this:</p>
<pre class="programlisting">
&lt;sitecatalog xmlns="http://pegasus.isi.edu/schema/sitecatalog"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="http://pegasus.isi.edu/schema/sitecatalog http://pegasus.isi.edu/schema/sc-4.0.xsd"
             version="4.0"&gt;

    &lt;site  handle="local" arch="x86" os="LINUX"&gt;
        &lt;directory type="shared-scratch" path="/lfs/shared-scratch/glite-sharedfs-example/work"&gt;
            &lt;file-server operation="all" url="file:///lfs/local-scratch/glite-sharedfs-example/work"/&gt;
        &lt;/directory&gt;
        &lt;directory type="local-storage" path="/shared-scratch//glite-sharedfs-example/outputs"&gt;
            &lt;file-server operation="all" url="file:///lfs/local-scratch/glite-sharedfs-example/outputs"/&gt;
        &lt;/directory&gt;
    &lt;/site&gt;

    &lt;site  handle="local-pbs" arch="x86" os="LINUX"&gt;

        &lt;!-- the following is a shared directory shared amongst all the nodes in the cluster --&gt;
        &lt;directory type="shared-scratch" path="/lfs/glite-sharedfs-example/local-pbs/shared-scratch"&gt;
            &lt;file-server operation="all" url="file:///lfs/glite-sharedfs-example/local-pbs/shared-scratch"/&gt;
        &lt;/directory&gt;

        &lt;profile namespace="env" key="PEGASUS_HOME"&gt;/lfs/software/pegasus/pegasus-4.2.0&lt;/profile&gt;

        &lt;profile namespace="pegasus" key="style" &gt;glite&lt;/profile&gt;

        &lt;profile namespace="condor" key="grid_resource"&gt;batch pbs&lt;/profile&gt;
        &lt;profile namespace="pegasus" key="queue"&gt;batch&lt;/profile&gt;
        &lt;profile namespace="pegasus" key="runtime"&gt;30000&lt;/profile&gt;
    &lt;/site&gt;

&lt;/sitecatalog&gt;
    </pre>
<div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>Starting 4.2.1, in the examples directory you can find a glite
      shared filesystem example that you can use to test out this
      configuration.</p>
</div>
<p>You probably don't need to know this, but Pegasus generates a
    <code class="literal">+remote_cerequirements</code> expression for an HTCondor glite
    job based on the Pegasus profiles associated with the job. This expression
    is passed to glite and used by the
    <code class="literal">*_local_submit_attributes.sh</code> scripts installed by
    <code class="literal">pegasus-configure-glite</code> to generate the correct batch
    submit script. An example <code class="literal">+remote_cerequirements</code>
    classad expression in the HTCondor submit file looks like this:</p>
<pre class="programlisting"><span class="bold"><strong>+remote_cerequirements = JOBNAME=="preprocessj1" &amp;&amp; PASSENV==1 &amp;&amp; WALLTIME=="01:00:00" &amp;&amp; \
 EXTRA_ARGUMENTS=="-N testjob -l walltime=01:23:45 -l nodes=2" &amp;&amp; \
 MYENV=="CONDOR_JOBID=$(cluster).$(process),PEGASUS_DAG_JOB_ID=preprocess_j1,PEGASUS_HOME=/usr,PEGASUS_WF_UUID=aae14bc4-b2d1-4189-89ca-ccd99e30464f"</strong></span></pre>
<p>The job name and environment variables are automatically passed
    through to the remote job.</p>
<p>The following sections document the mapping of Pegasus profiles to
    batch system job requirements as implemented by Pegasus, HTCondor, and
    glite.</p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="glite_mappings"></a>7.7.1. Setting job requirements</h3></div></div></div>
<p>The job requirements are constructed based on the following
      profiles:</p>
<div class="table">
<a name="idm3592"></a><p class="title"><b>Table 7.1. Mapping of Pegasus Profiles to Job Requirements</b></p>
<div class="table-contents"><table class="table" summary="Mapping of Pegasus Profiles to Job Requirements" border="1">
<colgroup>
<col>
<col>
<col>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Profile Key</th>
<th align="center">Key in +remote_cerequirements</th>
<th>PBS Parameter</th>
<th>SGE Parameter</th>
<th>Moab Parameter</th>
<th>Cobalt Parameter</th>
<th>Description</th>
</tr></thead>
<tbody>
<tr>
<td>pegasus.cores</td>
<td>CORES</td>
<td>n/a</td>
<td>-pe ompi</td>
<td>n/a</td>
<td>--proccount cores</td>
<td>Pegasus uses cores to calculate either nodes or ppn. If
              cores and ppn are specified, then nodes is computed. If cores
              and nodes is specified, then ppn is computed. If both nodes and
              ppn are specified, then cores is ignored. The resulting values
              for nodes and ppn are used to set the job requirements for PBS
              and Moab. If neither nodes nor ppn is specified, then no
              requirements are set in the PBS or Moab submit script. For SGE,
              how the processes are distributed over nodes depends on how the
              parallel environment has been configured; it is set to 'ompi' by
              default.</td>
</tr>
<tr>
<td>pegasus.nodes</td>
<td>NODES</td>
<td>-l nodes</td>
<td>n/a</td>
<td>-l nodes</td>
<td>-n nodes</td>
<td>This specifies the number of nodes that the job should
              use. This is not used for SGE.</td>
</tr>
<tr>
<td>pegasus.ppn</td>
<td>PROCS</td>
<td>-l ppn</td>
<td>n/a</td>
<td>-l ppn</td>
<td>--mode c[ppn]</td>
<td>This specifies the number of processors per node that the
              job should use. This is not used for SGE.</td>
</tr>
<tr>
<td>pegasus.runtime</td>
<td>WALLTIME</td>
<td>-l walltime</td>
<td>-l h_rt</td>
<td>-l walltime</td>
<td>-t walltime</td>
<td>This specifies the maximum runtime for the job in
              seconds. It should be an integer value. Pegasus converts it to
              the "hh:mm:ss" format required by the batch system. The value is
              rounded up to the next whole minute.</td>
</tr>
<tr>
<td>pegasus.memory</td>
<td>PER_PROCESS_MEMORY</td>
<td>-l pmem</td>
<td>-l h_vmem</td>
<td>-l pmem</td>
<td>n/a</td>
<td>This specifies the maximum amount of physical memory used
              by any process in the job. For example, if the job runs four
              processes and each requires up to 2 GB (gigabytes) of memory,
              then this value should be set to "2gb" for PBS and Moab, and
              "2G" for SGE. The corresponding PBS directive would be "#PBS -l
              pmem=2gb".</td>
</tr>
<tr>
<td>pegasus.project</td>
<td>PROJECT</td>
<td>-A project_name</td>
<td>n/a</td>
<td>-A project_name</td>
<td>-A project_name</td>
<td>Causes the job time to be charged to or associated with a
              particular project/account. This is not used for SGE.</td>
</tr>
<tr>
<td>pegasus.queue</td>
<td>n/a</td>
<td>-q</td>
<td>-q</td>
<td>-q</td>
<td> </td>
<td>This specifies the queue for the job. This profile does
              not have a corresponding value in
              <code class="literal">+remote_cerequirements</code>. Instead, Pegasus sets
              the <code class="literal">batch_queue</code> key in the Condor submit
              file, which gLite/blahp translates into the appropriate batch
              system requirement.</td>
</tr>
<tr>
<td>globus.totalmemory</td>
<td>TOTAL_MEMORY</td>
<td>-l mem</td>
<td>n/a</td>
<td>-l mem</td>
<td>n/a</td>
<td>The total memory that your job requires. It is usually
              better to just specify the pegasus.memory profile. This is not
              mapped for SGE.</td>
</tr>
<tr>
<td>pegasus.glite.arguments</td>
<td>EXTRA_ARGUMENTS</td>
<td>prefixed by "#PBS"</td>
<td>prefixed by "#?"</td>
<td>prefixed by "#MSUB"</td>
<td>n/a</td>
<td>This specifies the extra arguments that must appear in
              the generated submit script for a job. The value of this profile
              is added to the submit script prefixed by the batch
              system-specific value. These requirements override any
              requirements specified using other profiles. This is useful when
              you want to pass through special options to the underlying batch
              system. For example, on the USC cluster we use resource
              properties to specify the network type. If you want to use the
              Myrinet network, you must specify something like "-l
              nodes=8:ppn=2:myri". For infiniband, you would use something
              like "-l nodes=8:ppn=2:IB". In that case, both the nodes and ppn
              profiles would be effectively ignored.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>The above key mappings for PBS and SGE are supported in Pegasus
        4.6.0 or later. The Moab mappings are supported in Pegasus 4.6.1 and
        later.</p>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm3681"></a>7.7.2. Specifying a remote directory for the job</h3></div></div></div>
<p>gLite/blahp does not follow the
      <code class="literal">remote_initialdir</code> or <code class="literal">initialdir</code>
      classad directives. Therefore, all the jobs that have the
      <code class="literal">glite</code> style applied don't have a remote directory
      specified in the submit script. Instead, Pegasus uses Kickstart to
      change to the working directory when the job is launched on the remote
      system.</p>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="creamce_submission.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="execution_environments.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="bosco_sdsc.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.6. Remote Cluster using CREAMCE </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.8. SDSC Comet with BOSCO glideins</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
