#!/usr/bin/env python3

import sys
import json

print("######################")
print("#### LOCAL3 RULES ####")
print("######################")
print("")

syslogTemplate = """template(name="submitLog" type="string" string="%timereported:::date-unixtimestamp% [%timereported:::date-wdayname% %timereported:::date-rfc3164% %timereported:::date-year%] %$.logmsg%\\n")
template(name="submitMissing" type="string" string="%timereported:::date-unixtimestamp% [%timereported:::date-wdayname% %timereported:::date-rfc3164% %timereported:::date-year%] %programname% (%procid%) %msg%\\n")"""

print(syslogTemplate)
print("")

with open(sys.argv[1], 'r') as jsonFile:
   sysLogMap = json.load(jsonFile)

print("""if ($syslogfacility-text == "local3") then {""")

nSpecialCriticalLogs = 0
nPrograms = 0
for program in sysLogMap.keys():
   if 'criticalLogFile' in sysLogMap[program]:
      nSpecialCriticalLogs += 1

   nPrograms += 1

   if nPrograms == 1:
      print("""   if        ($msg startswith "%s") then {""" % (program))
   else:
      print("""   } else if ($msg startswith "%s") then {""" % (program))
   print("""      set $.logmsg = replace($msg,"%s ","");""" % (program))
   print("""      action(type="omfile" file="%s" template="submitLog")""" % (sysLogMap[program]['logFile']))

print("""   } else {""")
print("""      action(type="omfile" file="/var/log/submit/missingSysLog.log" template="submitMissing")""")
print("""   }""")

print("""   if ($syslogseverity-text == "crit") then {""")
if nSpecialCriticalLogs:
   nPrograms = 0
   for program in sysLogMap.keys():
      if 'criticalLogFile' in sysLogMap[program]:
         nPrograms += 1

         if nPrograms == 1:
            if nSpecialCriticalLogs > 1:
               print("""      if        ($msg startswith "%s") then {""" % (program))
            else:
               print("""      if ($msg startswith "%s") then {""" % (program))
         else:
            print("""      } else if ($msg startswith "%s") then {""" % (program))
         print("""         set $.logmsg = replace($msg,"%s ","");""" % (program))
         print("""         action(type="omfile" file="%s" template="submitLog")""" % (sysLogMap[program]['criticalLogFile']))
   print("""      } else {""")
   print("""         action(type="omfile" file="/var/log/submit/security.log" template="submitMissing")""")
   print("""      }""")
else:
   print("""      action(type="omfile" file="/var/log/submit/security.log" template="submitMissing")""")
print("""   }""")
print("""   stop""")
print("""}""")

stdOutErrTemplate = """template(name="submitStd" type="string" string="%timereported:::date-unixtimestamp% [%timereported:::date-wdayname% %timereported:::date-rfc3164% %timereported:::date-year%] (%procid%) %msg%\\n")"""

print("")
print(stdOutErrTemplate)
print("")

nPrograms = 0
for program in sysLogMap.keys():
   if sysLogMap[program]['logStdoutStderr']:
      nPrograms += 1

      if nPrograms == 1:
         print("""if        ($programname == "%s") then {""" % (program))
      else:
         print("""} else if ($programname == "%s") then {""" % (program))
      print("""   action(type="omfile" file="%s" template="submitStd")""" % (sysLogMap[program]['logFile']))
      print("""   stop""")
print("""}""")
print("")
