# -*- coding: utf-8 -*-
#
# HUBzero LDAP permission extensions for Trac
#
# Copyright 2006-2009 by Purdue Research Foundation, West Lafayette, IN 47906.
# All rights reserved.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License, version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# ===============================================================================
#
# Portions of this work are based on the work of Emmanuel Blot.
# Used under license:
#
# Copyright (C) 2005-2006 Emmanuel Blot <emmanuel.blot@free.fr>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. The name of the author may not be used to endorse or promote
#    products derived from this software without specific prior
#    written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
# GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

from trac.config import Configuration
from ldapplugin.api import LdapPermissionGroupProvider,LdapPermissionStore
from trac.test import EnvironmentStub

import unittest

class LdapGroupProviderTestCase(unittest.TestCase):

    def setUp(self):
        self.env = EnvironmentStub(default_data=True)
        self.env.config.set('ldap', 'enable', 'true')
        self.env.config.set('ldap', 'basedn', 'dc=example,dc=org')
        self.env.config.set('ldap', 'host', 'xebian')

    def test_permissiongroup(self):
        gp = LdapPermissionGroupProvider(self.env)
        groups = gp.get_permission_groups('joeuser')
        assert len(groups) >= 1
        assert '@users' in groups

class LdapPermissionStoreTestCase(unittest.TestCase):

    def setUp(self):
        self.env = EnvironmentStub(default_data=True)
        self.env.config.set('ldap', 'enable', 'true')
        self.env.config.set('ldap', 'basedn', 'dc=example,dc=org')
        self.env.config.set('ldap', 'host', 'xebian')
        self.env.config.set('ldap', 'store_bind', 'true')
        self.env.config.set('ldap', 'bind_user', 'trac')
        self.env.config.set('ldap', 'bind_passwd', 'Trac')
        self.env.config.set('ldap', 'permfilter', 'objectclass=groupofnames')
        self.action1 = 'FILE_VIEW'
        self.action2 = 'TICKET_CREATE'

    #def test_userPermissions(self):
    #    ps = LdapPermissionStore(self.env)
    #    perms = ps.get_user_permissions('@users')
    #    action = 'MILESTONE_VIEW'
    #    self.assertEqual(perms.has_key(action), True)
    #    self.assertEqual(perms[action], True)

    def test_store(self):
        self.ps = LdapPermissionStore(self.env)
        self.ps.grant_permission('@users', self.action1)
        self.ps.grant_permission('@users', self.action2)
        perms = self.ps.get_user_permissions('@users')
        self.assertEqual(perms.has_key(self.action1), True)
        self.assertEqual(perms[self.action1], True)
        self.assertEqual(perms.has_key(self.action2), True)
        self.assertEqual(perms[self.action2], True)

        self.ps = LdapPermissionStore(self.env)
        perms = self.ps.get_all_permissions()
        for perm in perms:
            print perm, "\n"

        self.ps.revoke_permission('@users', self.action1)
        perms = self.ps.get_user_permissions('@users')
        self.assertEqual(perms.has_key(self.action1), False)
        self.ps.revoke_permission('@users', self.action2)
        perms = self.ps.get_user_permissions('@users')
        self.assertEqual(perms.has_key(self.action2), False)

def suite():
    suite = unittest.TestSuite()
    suite.addTest(LdapGroupProviderTestCase("group"))
    suite.addTest(LdapPermissionStoreTestCase("store"))
    return suite

if __name__ == '__main__':
    unittest.main()

