# @package      hubzero-use-apps
# @file         apps.sh
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#


CONFIG_DIRS=""

if [ -f /etc/debian_version ] ; then
   # determibe Debian OS version, 5 - lenny, 6 - squeeze, 7 - wheezy
   dist=debian
   os_version=$(cat /etc/debian_version | sed -e "s/\.[0-9]*//" -e "s/\.[0-9]*//" )
fi

if [ -f /etc/redhat-release ] ; then
   # determibe Red Hat OS version
   dist=rhel
   os_version=$(cat /etc/redhat-release | sed -e "s/\.[0-9]* \(.*\)//" -e "s/.* //")
fi

dist_version=${dist}${os_version}

# setup the name of the share directory where external software
# should be installed.
# share_base is for bit ambiguous software (probably scripts)
# share_arch is for bit specific software (32-bit vs 64-bit compiled stuff)
share_base="share"
share_arch=""
if [ $(uname -m) = x86_64 ] ; then
    # setup for 64-bit share envionments
    share_arch="share64"
elif [ $(uname -m) = x86 ] ; then
    # setup for 32-bit share envionments
    share_arch="share32"
else
    share_arch="share"
fi


# setup bit specific share environments
if   [ -d /apps/${share_arch}/${dist_version}/environ.d ] ; then
    CONFIG_DIRS="$CONFIG_DIRS /apps/${share_arch}/${dist_version}/environ.d"
elif [ -d /apps/${share_arch}/environ.d ] ; then
    CONFIG_DIRS="$CONFIG_DIRS /apps/${share_arch}/environ.d"
elif [ -d /apps/${share_arch}/environ ] ; then
    CONFIG_DIRS="$CONFIG_DIRS /apps/${share_arch}/environ"
fi

if [ ${share_arch} != ${share_base} ] ; then
    # setup bit agnostic share environments
    if   [ -d /apps/${share_base}/${dist_version}/environ.d ] ; then
        CONFIG_DIRS="$CONFIG_DIRS /apps/${share_base}/${dist_version}/environ.d"
    elif [ -d /apps/${share_base}/environ.d ] ; then
        CONFIG_DIRS="$CONFIG_DIRS /apps/${share_base}/environ.d"
    elif [ -d /apps/${share_base}/environ ] ; then
        CONFIG_DIRS="$CONFIG_DIRS /apps/${share_base}/environ"
    fi
fi


# special setup for old production machines
if [ ${dist_version} = debian5 ] ; then
    # take care of debian 5 (lenny) installs on old production machines
    # during transition, these may exist in cooperation with one of the
    # previous bit specific environments. if we are operating in one
    # of these environments, we ignore previous CONFIG_DIRS settings
    # and hard code to use the old location.
    CONFIG_DIRS=""
    if   [ -d /apps/environ.d ] ; then
        CONFIG_DIRS="$CONFIG_DIRS /apps/environ.d"
    elif [ -d /apps/environ ] ; then
        CONFIG_DIRS="$CONFIG_DIRS /apps/environ"
    fi
fi


ENVIRON_CONFIG_DIRS="$ENVIRON_CONFIG_DIRS $CONFIG_DIRS"
export ENVIRON_CONFIG_DIRS
