import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;

/**
 * MultiLabel:  A label with multiple lines.  Also recognizes
 * text like __hello__ as italic.
 * @author  Michael McLennan (mmclennan@purdue.edu)
 */
public class MultiLabel extends Canvas {
    protected String text;
    protected FontMetrics fm;

    public MultiLabel(String s) {
        text = s;
        if (getFont() == null) {
            setFont(new Font("Helvetica", Font.PLAIN, 12));
        }

        Font normf = getFont();
        fm = getFontMetrics(normf);
        int xmax = 0;
        int y = fm.getMaxAscent();

        if (text != null) {
            String[] lines = text.split("\n");
            for (int i=0; i < lines.length; i++) {
                int w = fm.charsWidth(lines[i].toCharArray(),
                          0, lines[i].length());

                // keep the overall maximum size for below
                if (w > xmax) { xmax = w; }
                y += fm.getHeight();
            }
        }

        // set the proper overall size for the widget
        setSize(xmax, y-fm.getMaxAscent());
    }

    public void paint(Graphics g) {
        Font normf = getFont();
        Font italicf = normf.deriveFont(Font.ITALIC);
        fm = getFontMetrics(normf);
        int xmax = 0;
        int y = fm.getMaxAscent();

        if (text != null) {
            boolean italic = false;
            Font f = normf;

            // split on newlines and draw on separate lines
            String[] lines = text.split("\n");
            for (int i=0; i < lines.length; i++) {
                int x = 0;

                // switch between normal/italics for every __
                String[] parts = lines[i].split("__");
                for (int p=0; p < parts.length; p++) {
                    if (p > 0) {
                        // there must be one or more __ on this line
                        if (italic) {
                            italic = false;
                            f = normf;
                        } else {
                            italic = true;
                            f = italicf;
                        }
                        g.setFont(f);
                        fm = getFontMetrics(f);
                    }

                    int w = fm.charsWidth(parts[p].toCharArray(),
                              0, parts[p].length());
                    g.drawString(parts[p], x, y);
                    x += w;
                }

                // keep the overall maximum size for below
                if (x > xmax) { xmax = x; }
                y += fm.getHeight();
            }
        }

        // set the proper overall size for the widget
        setSize(xmax, y-fm.getMaxAscent());
    }
}
