//
//  Copyright (C) 2002 Cendio Systems.  All Rights Reserved.
//  Copyright (C) 2002 Constantin Kaplinsky.  All Rights Reserved.
//
//  This is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This software is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this software; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//

//
// ReloginPanel class implements panel with a button for logging in again,
// after fatal errors or disconnect
//


import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.net.*;

//
// The panel which implements the Relogin button
//

class ReloginPanel extends Panel implements ActionListener {
  Button reloginButton;
  Button signedButton;
  Button unsignedButton;
  Button whatisButton;
  Button closeButton;
  VncViewer viewer;

  //
  // Constructor.
  //
  public ReloginPanel(VncViewer v, String msg) {
    viewer = v;

    if (viewer.vc != null) {
      serverExit(viewer);
    }

    Font titleFont = new Font("Helvetica", Font.BOLD, 16);
    Font normalFont = new Font("Helvetica", Font.PLAIN, 12);

    GridBagLayout gb = new GridBagLayout();
    setLayout(gb);
    GridBagConstraints c = new GridBagConstraints();

    GridBagLayout gbtop = new GridBagLayout();
    Panel topPanel = new Panel(gbtop);
    add(topPanel);
    c.gridx = 0; c.gridy = 0;
    c.gridwidth = 2;
    c.fill = GridBagConstraints.HORIZONTAL;
    gb.setConstraints(topPanel,c);

    c.gridwidth = 1;
    c.fill = GridBagConstraints.NONE;
    c.insets = new Insets(2, 6, 6, 2);

    URL imgURL = getClass().getResource("icons/alert_large.gif");
    Image img = Toolkit.getDefaultToolkit().getImage(imgURL);

    ImageLabel alertIcon = new ImageLabel(img, 64, 61);
    topPanel.add(alertIcon);
    c.gridx = 0; c.gridy = 0;
    c.gridheight = 2;
    gbtop.setConstraints(alertIcon,c);

    Label err1 = new Label("Unable to connect");
    err1.setFont(titleFont);
    topPanel.add(err1);
    c.gridx = 1; c.gridy = 0;
    c.gridheight = 1;
    c.weightx = 1.0;
    c.anchor = GridBagConstraints.WEST;
    gbtop.setConstraints(err1,c);

    Label err2 = new Label(msg);
    err2.setFont(normalFont);
    topPanel.add(err2);
    c.gridy = 1;
    c.anchor = GridBagConstraints.NORTHWEST;
    c.weighty = 1.0;
    gbtop.setConstraints(err2,c);
    c.weighty = 0.0;

    c.insets = new Insets(4, 8, 8, 4);

    reloginButton = new Button("Retry");
    reloginButton.addActionListener(this);
    add(reloginButton);
    c.gridx = 0; c.gridy = 1;
    c.weightx = 0.0;
    c.anchor = GridBagConstraints.NORTHEAST;
    gb.setConstraints(reloginButton,c);

    MultiLabel retryExpl = new MultiLabel("This problem may have been caused\nby a network glitch.  Press __Retry__ to\nreestablish the network connection.");
    retryExpl.setFont(normalFont);
    add(retryExpl);
    c.gridx = 1; c.gridy = 1;
    c.fill = GridBagConstraints.BOTH;
    gb.setConstraints(retryExpl,c);

    if (viewer.isSigned) {
        unsignedButton = new Button("Try unsigned applet");
        unsignedButton.addActionListener(this);
        add(unsignedButton);
        c.gridx = 0; c.gridy = 2;
        c.anchor = GridBagConstraints.NORTHEAST;
        c.fill = GridBagConstraints.NONE;
        gb.setConstraints(unsignedButton,c);

        MultiLabel unsignedExpl = new MultiLabel("You are currently using the digitally\nsigned version of this applet, and\nthat normally fixes all connection\nproblems.  If you're still having\nproblems, however, you might try\nswitching back to the unsigned version\nof the applet.");
        unsignedExpl.setFont(normalFont);
        add(unsignedExpl);
        c.gridx = 1; c.gridy = 2;
        c.fill = GridBagConstraints.BOTH;
        gb.setConstraints(unsignedExpl,c);
    } else {
        signedButton = new Button("Switch to signed applet");
        signedButton.addActionListener(this);
        add(signedButton);
        c.gridx = 0; c.gridy = 2;
        c.anchor = GridBagConstraints.NORTHEAST;
        c.fill = GridBagConstraints.NONE;
        gb.setConstraints(signedButton,c);

        MultiLabel signedExpl = new MultiLabel("If pushing __Retry__ does not solve the\nproblem, your internet connection\nmay be guarded by a strict firewall.\nTo establish a connection, you must\nswitch to our __digitally signed applet__ \nand give it permission to run within\nyour browser.");
        signedExpl.setFont(normalFont);
        add(signedExpl);
        c.gridx = 1; c.gridy = 2;
        c.fill = GridBagConstraints.BOTH;
        c.insets = new Insets(4, 8, 8, 0);
        gb.setConstraints(signedExpl,c);

        whatisButton = new Button("What is a signed applet?");
        whatisButton.addActionListener(this);
        add(whatisButton);
        c.gridx = 1; c.gridy = 3;
        c.anchor = GridBagConstraints.WEST;
        c.fill = GridBagConstraints.NONE;
        c.insets = new Insets(0, 2, 2, 0);
        gb.setConstraints(whatisButton,c);
    }

    if (viewer.inSeparateFrame) {
        closeButton = new Button("Close window");
        closeButton.addActionListener(this);
        add(closeButton);
        c.gridx = 1; c.gridy = 4;
        c.anchor = GridBagConstraints.NORTHEAST;
        c.fill = GridBagConstraints.NONE;
        c.insets = new Insets(8, 0, 0, 8);
        gb.setConstraints(closeButton,c);
    }
  }

  //
  // This method is called when a button is pressed.
  //
  public synchronized void actionPerformed(ActionEvent evt) {
    if (viewer.inSeparateFrame)
      viewer.vncFrame.dispose();
    if (evt.getSource() == reloginButton) {
      viewer.rfbThread.stop();
      viewer.vncContainer.removeAll();
      viewer.init();
    }

    if (evt.getSource() == signedButton) {
      viewer.javascript("loadSignedApplet()");
      viewer.vncContainer.removeAll();
      viewer.rfbThread.stop();
    }

    if (evt.getSource() == unsignedButton) {
      viewer.javascript("loadUnsignedApplet()");
      viewer.vncContainer.removeAll();
      viewer.rfbThread.stop();
    }

    if (evt.getSource() == whatisButton) {
        viewer.javascript("explainSignedApplet()");
    }

  }

  // Called internally when the server tells us that it's exiting.
  public void serverExit(VncViewer viewer) {
    viewer.javascript("serverExit()");
    viewer.rfbThread.stop();
  }
}
