#!/bin/sh
# @package      hubzero-mw2-exec-proxy
# @file         make_exec_proxy_cert.sh
# @author       Pascal Meunier <pmeunier@purdue.edu>
# @copyright    Copyright (c) 2016-2017 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Packaging of original work by Richard L. Kennell
#
# Copyright (c) 2016-2017 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#


PEMFILE="/etc/mw-proxy/exec-proxy"

# Generate new certs if needed
if [ -e $PEMFILE ]; then
  echo "You already have an SSL pem file for the exec proxy; not replacing"
else
  echo "Creating generic self-signed certificate: $PEMFILE"
  echo "(replace with hand-crafted or authorized one if needed)."
  cd /etc/mw-proxy
  PATH=$PATH:/usr/bin/ssl
  FQDN=`hostname -f`
  MAILNAME=`cat /etc/mailname 2> /dev/null || hostname -f`
  (openssl req -new -x509 -days 365 -nodes -out $PEMFILE.cert -keyout $PEMFILE.key  > /dev/null 2>&1 <<+
.
.
.
HUBzero Middleware
$FQDN
$FQDN
root@$MAILNAME
+
  ) || echo "Warning : Bad SSL config, can't generate certificate."

  if [ -e $PEMFILE.key ]; then
    chown root:root $PEMFILE* || true
    chmod 0640 $PEMFILE* || true
  fi
fi
