#!/bin/sh
# @package      hubzero-mw2-front-virtualssh
# @file         session.sh
# @author       Pascal Meunier <pmeunier@purdue.edu>
# @copyright    Copyright (c) 2016-2017 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Based on prior work by Richard L. Kennell
#
# Copyright (c) 2016-2017 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

# not calling exec because it causes SSH processes to not be cleanly terminated when the connection is abruptly closed
# sudo -n: do not prompt the user for a password, fail if one is required
# experimental: run as user hzmw which can talk to the database and use the SSH key to talk to execution hosts
getent passwd hzmw > /dev/null
if [ $? -eq 0 ]; then
  # new code using lower privilege account
  # Does the user want SFTP?
  if [ "$SSH_ORIGINAL_COMMAND" == "internal-sftp" ]; then
    exec /usr/bin/chroot_sftp.py "$@"
    echo "SFTP failed.  Please contact a system administrator."
    exit 1
  fi
  # manage sessions as unprivileged user hzmw
  sudo -n -u hzmw /usr/bin/ssh_session_notroot.py "$@"
else
  # still using root
  sudo /usr/bin/ssh_session.py "$@"
fi
